/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.state;

import com.gtnewhorizon.gtnhlib.client.model.JSONVariant;
import com.gtnewhorizon.gtnhlib.client.model.Weighted;
import com.gtnewhorizon.gtnhlib.client.model.state.StateModelMap;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.MonopartDough;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.UnbakedModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class MonopartState
implements StateModelMap {
    private final Object2ObjectMap<StateMatch, ObjectList<Weighted<JSONVariant>>> variants;

    MonopartState(Object2ObjectMap<StateMatch, ObjectList<Weighted<JSONVariant>>> variants) {
        this.variants = Object2ObjectMaps.unmodifiable(variants);
    }

    @Override
    @Nullable
    public UnbakedModel selectModel(Map<String, String> properties) {
        ObjectIterator<Object2ObjectMap.Entry<StateMatch, ObjectList<Weighted<JSONVariant>>>> iter = Object2ObjectMaps.fastIterator(this.variants);
        while (iter.hasNext()) {
            Object2ObjectMap.Entry e = (Object2ObjectMap.Entry)iter.next();
            StateMatch match = (StateMatch)e.getKey();
            if (!match.matches(properties)) continue;
            return new MonopartDough((ObjectList)e.getValue());
        }
        return null;
    }

    static class StateMatch {
        private final boolean matchAll;
        private final Object2ObjectMap<String, String> states;

        StateMatch(String s) {
            String[] cases;
            if (s.isEmpty()) {
                this.matchAll = true;
                this.states = null;
                return;
            }
            this.matchAll = false;
            this.states = new Object2ObjectOpenHashMap<String, String>();
            for (String c : cases = s.split(",")) {
                int eidx = c.indexOf("=");
                if (eidx == -1) {
                    throw new RuntimeException("Unexpected blockstate case '" + c + "'!");
                }
                this.states.put(c.substring(0, eidx), c.substring(eidx + 1));
            }
        }

        boolean matches(Map<String, String> properties) {
            if (this.matchAll) {
                return true;
            }
            ObjectIterator<Object2ObjectMap.Entry<String, String>> iter = Object2ObjectMaps.fastIterator(this.states);
            while (iter.hasNext()) {
                Object2ObjectMap.Entry e = (Object2ObjectMap.Entry)iter.next();
                if (Objects.equals(properties.get(e.getKey()), e.getValue())) continue;
                return false;
            }
            return true;
        }
    }
}

