/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturedDraw;
import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.DrawCallback;
import com.gtnewhorizon.gtnhlib.client.renderer.ITessellatorInstance;
import com.gtnewhorizon.gtnhlib.client.renderer.QuadExtractor;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.util.ModelQuadUtil;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VAOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TessellatorManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"TessellatorManager");
    private static final ThreadLocal<CapturingTessellator> capturingTessellator = ThreadLocal.withInitial(CapturingTessellator::new);
    private static final ThreadLocal<ArrayList<CaptureState>> captureStack = ThreadLocal.withInitial(ArrayList::new);
    private static final Thread mainThread = Thread.currentThread();
    private static boolean isInCompilingCallback = false;

    public static Tessellator get() {
        ArrayList<CaptureState> stack = captureStack.get();
        if (!stack.isEmpty()) {
            return capturingTessellator.get();
        }
        if (TessellatorManager.isOnMainThread()) {
            return Tessellator.instance;
        }
        throw new IllegalStateException("Tried to get the Tessellator off the main thread when not capturing!");
    }

    public static boolean isCurrentlyCapturing() {
        CaptureState current = TessellatorManager.peekState();
        return current != null && current.mode == CaptureMode.CAPTURING;
    }

    static boolean isCurrentlyCompiling() {
        CaptureState current = TessellatorManager.peekState();
        return current != null && current.mode == CaptureMode.COMPILING;
    }

    public static boolean isOnMainThread() {
        return Thread.currentThread() == mainThread;
    }

    public static boolean isMainInstance(Object instance) {
        return instance == Tessellator.instance || TessellatorManager.isOnMainThread();
    }

    private static CaptureState peekState() {
        ArrayList<CaptureState> stack = captureStack.get();
        return stack.isEmpty() ? null : stack.get(stack.size() - 1);
    }

    private static CaptureState requireMode(CaptureMode expected, String errorMsg) {
        ArrayList<CaptureState> stack = captureStack.get();
        if (stack.isEmpty() || stack.get((int)(stack.size() - 1)).mode != expected) {
            throw new IllegalStateException(errorMsg);
        }
        return stack.get(stack.size() - 1);
    }

    private static void setVanillaTessellatorCompiling(boolean compiling) {
        Tessellator tessellator = Tessellator.instance;
        if (tessellator instanceof ITessellatorInstance) {
            ITessellatorInstance tessInst = (ITessellatorInstance)tessellator;
            tessInst.gtnhlib$setCompiling(compiling);
        }
    }

    private static boolean hasCompilingInStack(ArrayList<CaptureState> stack) {
        for (int i = stack.size() - 1; i >= 0; --i) {
            if (stack.get((int)i).mode != CaptureMode.COMPILING) continue;
            return true;
        }
        return false;
    }

    private static void saveUncommittedQuadsIfNeeded(ArrayList<CaptureState> stack, CapturingTessellator tess) {
        if (stack.isEmpty() || tess.getQuads().isEmpty()) {
            return;
        }
        CaptureState parent = stack.get(stack.size() - 1);
        if (parent.mode == CaptureMode.CAPTURING) {
            parent.capturedDraws.add(new CapturedDraw(ModelQuadUtil.deepCopyQuads(tess.getQuads()), new CapturingTessellator.Flags(tess.flags)));
            tess.getQuads().clear();
        }
    }

    public static void startCapturing() {
        TessellatorManager.startCapturingAndGet();
    }

    public static CapturingTessellator startCapturingAndGet() {
        ArrayList<CaptureState> stack = captureStack.get();
        CapturingTessellator tess = capturingTessellator.get();
        TessellatorManager.saveUncommittedQuadsIfNeeded(stack, tess);
        if (!tess.getQuads().isEmpty()) {
            throw new IllegalStateException("Tried to start capturing with existing collected Quads!");
        }
        tess.storeTranslation();
        stack.add(new CaptureState(CaptureMode.CAPTURING, null));
        return tess;
    }

    public static List<CapturedDraw> stopCapturingToDraws() {
        CaptureState currentState = TessellatorManager.requireMode(CaptureMode.CAPTURING, "Tried to stop capturing when not capturing!");
        ArrayList<CaptureState> stack = captureStack.get();
        CapturingTessellator tess = capturingTessellator.get();
        if (tess.isDrawing) {
            tess.draw();
        }
        stack.remove(stack.size() - 1);
        ArrayList<CapturedDraw> draws = new ArrayList<CapturedDraw>(currentState.capturedDraws);
        tess.restoreTranslation();
        if (!stack.isEmpty() && stack.get((int)(stack.size() - 1)).mode == CaptureMode.CAPTURING) {
            tess.getQuads().clear();
        } else {
            tess.discard();
        }
        return draws;
    }

    public static List<ModelQuadViewMutable> stopCapturingToPooledQuads() {
        List<CapturedDraw> draws = TessellatorManager.stopCapturingToDraws();
        ArrayList<ModelQuadViewMutable> allQuads = new ArrayList<ModelQuadViewMutable>();
        int size = draws.size();
        for (int i = 0; i < size; ++i) {
            allQuads.addAll(draws.get(i).quads());
        }
        return allQuads;
    }

    public static ByteBuffer stopCapturingToBuffer(VertexFormat format) {
        ByteBuffer buf = CapturingTessellator.quadsToBuffer(TessellatorManager.stopCapturingToPooledQuads(), format);
        capturingTessellator.get().clearQuads();
        return buf;
    }

    public static VertexBuffer stopCapturingToVBO(VertexFormat format) {
        return new VertexBuffer(format, 7).upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static VertexBuffer stopCapturingToVBO(VertexBuffer vbo, VertexFormat format) {
        if (vbo == null) {
            vbo = new VertexBuffer(format, 7);
        }
        return vbo.upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static VertexBuffer stopCapturingToVAO(VertexFormat format) {
        return VAOManager.createVAO(format, 7).upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static VertexBuffer stopCapturingToVAO(VertexBuffer vao, VertexFormat format) {
        if (vao == null) {
            vao = VAOManager.createVAO(format, 7);
        }
        return vao.upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static boolean shouldInterceptDraw(Tessellator tess) {
        return ((ITessellatorInstance)tess).gtnhlib$isCompiling();
    }

    public static int interceptDraw(Tessellator tess) {
        if (isInCompilingCallback) {
            throw new IllegalStateException("Tessellator.draw() called from within a compiling callback - this is not allowed!");
        }
        CaptureState current = TessellatorManager.requireMode(CaptureMode.COMPILING, "interceptDraw called but not in COMPILING mode!");
        if (current.callback == null) {
            throw new IllegalStateException("interceptDraw called but callback is null!");
        }
        CapturingTessellator helper = capturingTessellator.get();
        QuadExtractor.buildQuadsFromBuffer(tess.rawBuffer, tess.vertexCount, tess.drawMode, true, tess.hasBrightness, tess.hasColor, tess.hasNormals, 0, 0, 0, -1, helper.quadBuf, helper.collectedQuads, helper.flags);
        isInCompilingCallback = true;
        try {
            current.callback.onDraw(helper.collectedQuads, helper.flags);
        }
        finally {
            isInCompilingCallback = false;
        }
        helper.clearQuads();
        int result = tess.rawBufferIndex * 4;
        ((ITessellatorInstance)tess).discard();
        return result;
    }

    static int processDrawForCapturingTessellator(CapturingTessellator tess) {
        CaptureState current = TessellatorManager.peekState();
        QuadExtractor.buildQuadsFromBuffer(tess.rawBuffer, tess.vertexCount, tess.drawMode, tess.hasTexture, tess.hasBrightness, tess.hasColor, tess.hasNormals, -tess.offset.x, -tess.offset.y, -tess.offset.z, tess.shaderBlockId, tess.quadBuf, tess.collectedQuads, tess.flags);
        if (current != null) {
            if (current.mode == CaptureMode.COMPILING) {
                current.callback.onDraw(tess.collectedQuads, tess.flags);
                tess.clearQuads();
            } else if (current.mode == CaptureMode.CAPTURING) {
                current.capturedDraws.add(new CapturedDraw(ModelQuadUtil.deepCopyQuads(tess.collectedQuads), new CapturingTessellator.Flags(tess.flags)));
                tess.clearQuads();
            }
        }
        int result = tess.rawBufferIndex * 4;
        tess.discard();
        return result;
    }

    public static void cleanup() {
        CaptureState current;
        CapturingTessellator tessellator = capturingTessellator.get();
        ArrayList<CaptureState> stack = captureStack.get();
        if (TessellatorManager.isOnMainThread() && (current = TessellatorManager.peekState()) != null && current.mode == CaptureMode.COMPILING) {
            LOGGER.warn("[TessellatorManager] cleanup() called while compiling is active - this may indicate cleanup() called during display list compilation!", (Throwable)new Exception("Stack trace"));
            TessellatorManager.setVanillaTessellatorCompiling(false);
        }
        stack.clear();
        tessellator.discard();
        tessellator.clearQuads();
        isInCompilingCallback = false;
    }

    public static void setCompiling(DrawCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        if (!TessellatorManager.isOnMainThread()) {
            throw new IllegalStateException("Display list compilation can only happen on main thread!");
        }
        ArrayList<CaptureState> stack = captureStack.get();
        CapturingTessellator tess = capturingTessellator.get();
        if (!tess.getQuads().isEmpty()) {
            throw new IllegalStateException("Tried to start compiling with existing collected Quads!");
        }
        stack.add(new CaptureState(CaptureMode.COMPILING, callback));
        TessellatorManager.setVanillaTessellatorCompiling(true);
        tess.storeTranslation();
    }

    public static void stopCompiling() {
        if (!TessellatorManager.isOnMainThread()) {
            throw new IllegalStateException("stopCompiling() can only be called from main thread!");
        }
        TessellatorManager.requireMode(CaptureMode.COMPILING, "Not currently compiling!");
        ArrayList<CaptureState> stack = captureStack.get();
        CapturingTessellator tess = capturingTessellator.get();
        if (tess.isDrawing) {
            tess.draw();
        }
        stack.remove(stack.size() - 1);
        if (!TessellatorManager.hasCompilingInStack(stack)) {
            TessellatorManager.setVanillaTessellatorCompiling(false);
        }
        tess.clearQuads();
        tess.discard();
        tess.restoreTranslation();
    }

    private static class CaptureState {
        final CaptureMode mode;
        final DrawCallback callback;
        final List<CapturedDraw> capturedDraws = new ArrayList<CapturedDraw>();

        CaptureState(CaptureMode mode, DrawCallback callback) {
            this.mode = mode;
            this.callback = callback;
        }
    }

    private static enum CaptureMode {
        CAPTURING,
        COMPILING;

    }
}

