/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.cel.util;

import com.gtnewhorizon.gtnhlib.client.renderer.cel.api.util.NormI8;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuad;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import java.util.ArrayList;
import java.util.List;

public class ModelQuadUtil {
    public static final int POSITION_INDEX = 0;
    public static final int COLOR_INDEX = 5;
    public static final int TEXTURE_INDEX = 3;
    public static final int LIGHT_INDEX = 7;
    public static final int NORMAL_INDEX = 6;
    public static final int VERTEX_SIZE = 8;
    public static final int DEFAULT_COLOR = -1;
    public static final int DEFAULT_LIGHTMAP = 0xF000F0;

    public static int vertexOffset(int vertexIndex) {
        return vertexIndex * 8;
    }

    public static ModelQuadFacing findNormalFace(float x, float y, float z) {
        if (!(Float.isFinite(x) && Float.isFinite(y) && Float.isFinite(z))) {
            return ModelQuadFacing.UNASSIGNED;
        }
        float maxDot = 0.0f;
        ModelQuadFacing closestFace = null;
        for (ModelQuadFacing face : ModelQuadFacing.DIRECTIONS) {
            float dot = x * (float)face.getStepX() + y * (float)face.getStepY() + z * (float)face.getStepZ();
            if (!(dot > maxDot)) continue;
            maxDot = dot;
            closestFace = face;
        }
        if (closestFace != null && Math.abs(maxDot - 1.0f) < 1.0E-5f) {
            return closestFace;
        }
        return ModelQuadFacing.UNASSIGNED;
    }

    public static ModelQuadFacing findNormalFace(int normal) {
        return ModelQuadUtil.findNormalFace(NormI8.unpackX(normal), NormI8.unpackY(normal), NormI8.unpackZ(normal));
    }

    public static ModelQuadFacing findLightFace(int normal) {
        float x = NormI8.unpackX(normal);
        float y = NormI8.unpackY(normal);
        float z = NormI8.unpackZ(normal);
        float max = Math.max(Math.max(Math.abs(x), Math.abs(y)), Math.abs(z));
        if (max == x) {
            return x < 0.0f ? ModelQuadFacing.NEG_X : ModelQuadFacing.POS_X;
        }
        if (max == z) {
            return z < 0.0f ? ModelQuadFacing.NEG_Z : ModelQuadFacing.POS_Z;
        }
        return y < 0.0f ? ModelQuadFacing.NEG_Y : ModelQuadFacing.POS_Y;
    }

    public static int calculateNormal(ModelQuadView quad) {
        float normZ;
        float dx0;
        float dx1;
        float normY;
        float dy1;
        float dz0;
        float x0 = quad.getX(0);
        float y0 = quad.getY(0);
        float z0 = quad.getZ(0);
        float x1 = quad.getX(1);
        float y1 = quad.getY(1);
        float z1 = quad.getZ(1);
        float x2 = quad.getX(2);
        float y2 = quad.getY(2);
        float z2 = quad.getZ(2);
        float x3 = quad.getX(3);
        float y3 = quad.getY(3);
        float dy0 = y2 - y0;
        float z3 = quad.getZ(3);
        float dz1 = z3 - z1;
        float normX = dy0 * dz1 - (dz0 = z2 - z0) * (dy1 = y3 - y1);
        float l = (float)Math.sqrt(normX * normX + (normY = dz0 * (dx1 = x3 - x1) - (dx0 = x2 - x0) * dz1) * normY + (normZ = dx0 * dy1 - dy0 * dx1) * normZ);
        if (l != 0.0f) {
            normX /= l;
            normY /= l;
            normZ /= l;
        }
        return NormI8.pack(normX, normY, normZ);
    }

    public static int mergeBakedLight(int packedLight, int vanillaLightEmission, int calcLight) {
        if (packedLight == 0 && vanillaLightEmission == 0) {
            return calcLight;
        }
        int psl = packedLight >> 16 & 0xFF;
        int csl = calcLight >> 16 & 0xFF;
        int pbl = packedLight & 0xFF;
        int cbl = calcLight & 0xFF;
        int bl = Math.max(Math.max(pbl, cbl), vanillaLightEmission);
        int sl = Math.max(Math.max(psl, csl), vanillaLightEmission);
        return sl << 16 | bl;
    }

    public static List<ModelQuadViewMutable> deepCopyQuads(List<ModelQuadViewMutable> sourceQuads) {
        int size = sourceQuads.size();
        ArrayList<ModelQuadViewMutable> quadCopies = new ArrayList<ModelQuadViewMutable>(size);
        for (int i = 0; i < size; ++i) {
            quadCopies.add(new ModelQuad(sourceQuads.get(i)));
        }
        return quadCopies;
    }
}

