/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuad;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.util.ObjectPooler;
import java.util.List;

public final class QuadExtractor {
    private static final int VERTEX_STRIDE = 8;

    private QuadExtractor() {
    }

    public static void buildQuadsFromBuffer(int[] rawBuffer, int vertexCount, int drawMode, boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelQuad> quadBuf, List<ModelQuadViewMutable> collectedQuads, CapturingTessellator.Flags flags) {
        flags.copyFrom(hasTexture, hasBrightness, hasColor, hasNormals);
        int verticesPerPrimitive = drawMode == 7 ? 4 : 3;
        for (int quadI = 0; quadI < vertexCount / verticesPerPrimitive; ++quadI) {
            int srcOffset = quadI * (verticesPerPrimitive * 8);
            if (QuadExtractor.isEmptyQuad(rawBuffer, srcOffset)) continue;
            ModelQuad quad = quadBuf.getInstance();
            quad.setState(rawBuffer, srcOffset, flags, drawMode, offsetX, offsetY, offsetZ);
            quad.setShaderBlockId(shaderBlockId);
            collectedQuads.add(quad);
        }
    }

    private static boolean isEmptyQuad(int[] rawBuffer, int srcOffset) {
        for (int axis = 0; axis < 3; ++axis) {
            int firstVal = rawBuffer[srcOffset + axis];
            if (firstVal != rawBuffer[srcOffset + 8 + axis]) {
                return false;
            }
            if (firstVal != rawBuffer[srcOffset + 16 + axis]) {
                return false;
            }
            if (firstVal == rawBuffer[srcOffset + 24 + axis]) continue;
            return false;
        }
        return true;
    }
}

