/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.shader;

import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.mixins.early.EntityRendererAccessor;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

@EventBusSubscriber
public class UniverseShader
extends ShaderProgram {
    public static final UniverseShader INSTANCE = new UniverseShader();
    private static final int COSMIC_COUNT = 10;
    public static final String[] COSMIC_TEXTURES = new String[10];
    public static final FloatBuffer COSMIC_UVS;
    public static final IIcon[] COSMIC_ICONS;
    public static final float[] LIGHT_LEVEL;
    public static boolean inventoryRender;
    public static float cosmicOpacity;

    private UniverseShader() {
        super("gtnhlib", "shaders/universe/universe.vert", "shaders/universe/universe.frag");
    }

    @SubscribeEvent
    public static void letsMakeAQuilt(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 1) {
            return;
        }
        for (int i = 0; i < COSMIC_TEXTURES.length; ++i) {
            IIcon icon;
            UniverseShader.COSMIC_ICONS[i] = icon = event.map.func_94245_a(COSMIC_TEXTURES[i]);
        }
    }

    @SubscribeEvent
    public static void pushTheCosmicFancinessToTheLimit(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (IIcon icon : COSMIC_ICONS) {
                COSMIC_UVS.put(icon.func_94209_e());
                COSMIC_UVS.put(icon.func_94206_g());
                COSMIC_UVS.put(icon.func_94212_f());
                COSMIC_UVS.put(icon.func_94210_h());
            }
            COSMIC_UVS.flip();
        }
    }

    @SubscribeEvent
    public static void makeCosmicStuffLessDumbInGUIs(GuiScreenEvent.DrawScreenEvent.Pre event) {
        inventoryRender = true;
    }

    @SubscribeEvent
    public static void finishMakingCosmicStuffLessDumbInGUIs(GuiScreenEvent.DrawScreenEvent.Post event) {
        inventoryRender = false;
    }

    @Override
    public void use() {
        super.use();
        Minecraft mc = Minecraft.func_71410_x();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (!inventoryRender) {
            yaw = (float)((double)(mc.field_71439_g.field_70177_z * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.field_71439_g.field_70125_A * 2.0f) * Math.PI / 360.0));
        } else {
            scale = 25.0f;
        }
        int time2 = INSTANCE.getUniformLocation("time2");
        GL20.glUniform1f((int)time2, (float)mc.field_71439_g.field_70173_aa);
        int x = INSTANCE.getUniformLocation("yaw");
        GL20.glUniform1f((int)x, (float)yaw);
        int z = INSTANCE.getUniformLocation("pitch");
        GL20.glUniform1f((int)z, (float)pitch);
        int l = INSTANCE.getUniformLocation("lightlevel");
        GL20.glUniform3f((int)l, (float)LIGHT_LEVEL[0], (float)LIGHT_LEVEL[1], (float)LIGHT_LEVEL[2]);
        int lightmix = INSTANCE.getUniformLocation("lightmix");
        GL20.glUniform1f((int)lightmix, (float)0.2f);
        int uvs = INSTANCE.getUniformLocation("cosmicuvs");
        GL20.glUniformMatrix2((int)uvs, (boolean)false, (FloatBuffer)COSMIC_UVS);
        int s = INSTANCE.getUniformLocation("externalScale");
        GL20.glUniform1f((int)s, (float)scale);
        int o = INSTANCE.getUniformLocation("opacity");
        GL20.glUniform1f((int)o, (float)cosmicOpacity);
    }

    public static void setLightFromLocation(World world, int x, int y, int z) {
        if (world == null) {
            UniverseShader.setLightLevel(1.0f);
            return;
        }
        int coord = world.func_72802_i(x, y, z, 0);
        int[] map = ((EntityRendererAccessor)Minecraft.func_71410_x().field_71460_t).getLightmapColors();
        if (map == null) {
            UniverseShader.setLightLevel(1.0f);
            return;
        }
        int mx = coord % 65536 / 16;
        int my = coord / 65536 / 16;
        int lightColour = map[Math.max(0, Math.min(map.length - 1, my * 16 + mx))];
        UniverseShader.setLightLevel((float)(lightColour >> 16 & 0xFF) / 256.0f, (float)(lightColour >> 8 & 0xFF) / 256.0f, (float)(lightColour & 0xFF) / 256.0f);
    }

    public static void setLightLevel(float level) {
        UniverseShader.setLightLevel(level, level, level);
    }

    public static void setLightLevel(float r, float g, float b) {
        UniverseShader.LIGHT_LEVEL[0] = Math.max(0.0f, Math.min(1.0f, r));
        UniverseShader.LIGHT_LEVEL[1] = Math.max(0.0f, Math.min(1.0f, g));
        UniverseShader.LIGHT_LEVEL[2] = Math.max(0.0f, Math.min(1.0f, b));
    }

    static {
        for (int i = 0; i < 10; ++i) {
            UniverseShader.COSMIC_TEXTURES[i] = "gtnhlib:universe/cosmic" + i;
        }
        COSMIC_UVS = BufferUtils.createFloatBuffer((int)(4 * COSMIC_TEXTURES.length));
        COSMIC_ICONS = new IIcon[COSMIC_TEXTURES.length];
        LIGHT_LEVEL = new float[3];
        inventoryRender = false;
        cosmicOpacity = 1.0f;
    }
}

