/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.mixins.early;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.IModelCustomExt;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WavefrontObject.class}, remap=false)
public abstract class MixinWavefrontObject
implements IModelCustomExt {
    @Unique
    private VertexBuffer vertexBuffer;
    @Shadow
    private GroupObject currentGroupObject;
    @Unique
    private VertexFormat format = DefaultVertexFormat.POSITION_TEXTURE_NORMAL;

    @Shadow
    public abstract void tessellateAll(Tessellator var1);

    @Override
    public void rebuildVBO() {
        this.rebuild(false);
    }

    private void rebuild(boolean vao) {
        if (this.currentGroupObject == null) {
            throw new RuntimeException("No group object selected");
        }
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        TessellatorManager.startCapturing();
        CapturingTessellator tess = (CapturingTessellator)TessellatorManager.get();
        tess.func_78371_b(this.currentGroupObject.glDrawingMode);
        this.tessellateAll(tess);
        this.vertexBuffer = vao ? TessellatorManager.stopCapturingToVAO(this.format) : TessellatorManager.stopCapturingToVBO(this.format);
    }

    @Override
    public void renderAllVBO() {
        if (this.vertexBuffer == null) {
            this.rebuild(false);
        }
        this.vertexBuffer.render();
    }

    @Override
    public void renderAllVAO() {
        if (this.vertexBuffer == null) {
            this.rebuild(true);
        }
        this.vertexBuffer.render();
    }

    @Override
    public void setVertexFormat(VertexFormat format) {
        this.setVertexFormat(format, false);
    }

    @Override
    public void setVertexFormat(VertexFormat format, boolean vao) {
        this.format = format;
        if (this.vertexBuffer != null && this.vertexBuffer.getVertexFormat() != format) {
            this.rebuild(vao);
        }
    }
}

