/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import com.gtnewhorizon.gtnhlib.blockstate.core.InvalidPropertyJsonException;
import com.gtnewhorizon.gtnhlib.blockstate.core.InvalidPropertyTextException;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface BlockProperty<TValue> {
    public static final Gson GSON = new Gson();

    public String getName();

    public Type getType();

    public boolean hasTrait(BlockPropertyTrait var1);

    default public TValue copy(TValue value) {
        return value;
    }

    @ApiStatus.OverrideOnly
    default public Gson getGson() {
        return GSON;
    }

    default public TValue deserialize(JsonElement element) {
        try {
            return (TValue)this.getGson().fromJson(element, this.getType());
        }
        catch (JsonSyntaxException e) {
            throw new InvalidPropertyJsonException("Could not deserialize " + this.getType().getTypeName(), e);
        }
    }

    default public JsonElement serialize(TValue value) {
        return this.getGson().toJsonTree(value);
    }

    default public TValue parse(String text) throws InvalidPropertyTextException {
        try {
            return (TValue)this.getGson().fromJson(text, this.getType());
        }
        catch (JsonSyntaxException e) {
            throw new InvalidPropertyTextException("Could not parse " + this.getType().getTypeName(), e);
        }
    }

    default public String stringify(TValue value) {
        return this.getGson().toJson(value);
    }

    default public boolean appliesTo(IBlockAccess world, int x, int y, int z, Block block, int meta, @Nullable TileEntity tile) {
        return true;
    }

    default public TValue getValue(IBlockAccess world, int x, int y, int z) {
        throw new UnsupportedOperationException();
    }

    default public void setValue(World world, int x, int y, int z, TValue value) {
        throw new UnsupportedOperationException();
    }

    default public boolean appliesTo(ItemStack stack, Item item, int meta) {
        return true;
    }

    default public TValue getValue(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    default public void setValue(ItemStack stack, TValue value) {
        throw new UnsupportedOperationException();
    }

    public static <T> T getIndexSafe(T[] array, int index) {
        return array == null || index < 0 || index >= array.length ? null : (T)array[index];
    }

    public static <T> T getIndexSafe(List<T> list, int index) {
        return list == null || index < 0 || index >= list.size() ? null : (T)list.get(index);
    }
}

