/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.core;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockState;
import com.gtnewhorizon.gtnhlib.blockstate.core.TransformableProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.VectorTransformableProperty;
import com.gtnewhorizon.gtnhlib.blockstate.registry.BlockPropertyRegistry;
import com.gtnewhorizon.gtnhlib.geometry.DirectionTransform;
import com.gtnewhorizon.gtnhlib.geometry.TransformLike;
import com.gtnewhorizon.gtnhlib.geometry.VectorTransform;
import com.gtnewhorizon.gtnhlib.util.ObjectPooler;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class BlockStateImpl
implements BlockState {
    private Block block;
    private int meta;
    private final Map<String, BlockProperty<?>> properties = new HashMap(4);
    private final Map<BlockProperty<?>, Object> values = new HashMap(4);
    private static final ObjectPooler<BlockStateImpl> POOL = new ObjectPooler<BlockStateImpl>(BlockStateImpl::new);

    public static BlockStateImpl getInstance() {
        return POOL.getInstance().assertIsDefault();
    }

    public BlockStateImpl assertIsDefault() {
        if (this.block != null) {
            throw new RuntimeException("BlockStateImpl reference was mutated while in the pool; block was set to " + this.block);
        }
        if (this.meta != 0) {
            throw new RuntimeException("BlockStateImpl reference was mutated while in the pool; meta was set to " + this.meta);
        }
        if (!this.properties.isEmpty()) {
            throw new RuntimeException("BlockStateImpl reference was mutated while in the pool; properties was set to " + this.properties);
        }
        if (!this.values.isEmpty()) {
            throw new RuntimeException("BlockStateImpl reference was mutated while in the pool; values was set to " + this.values);
        }
        return this;
    }

    public BlockStateImpl reset() {
        this.block = null;
        this.meta = 0;
        this.properties.clear();
        this.values.clear();
        return this;
    }

    public BlockStateImpl copy(BlockStateImpl other) {
        this.reset();
        this.block = other.block;
        this.meta = other.meta;
        this.properties.putAll(other.properties);
        this.values.putAll(other.values);
        return this;
    }

    public BlockStateImpl fromWorld(IBlockAccess world, int x, int y, int z) {
        this.block = world.func_147439_a(x, y, z);
        this.meta = world.func_72805_g(x, y, z);
        BlockPropertyRegistry.getProperties(world, x, y, z, this.properties);
        this.values.clear();
        this.properties.forEach((name, property) -> this.values.put((BlockProperty<?>)property, property.getValue(world, x, y, z)));
        return this;
    }

    public BlockStateImpl fromStack(ItemStack stack) {
        ItemBlock itemBlock = (ItemBlock)Objects.requireNonNull(stack.func_77973_b(), "Item cannot be null");
        this.block = itemBlock.field_150939_a;
        this.meta = itemBlock.func_77647_b(stack.func_77960_j());
        BlockPropertyRegistry.getProperties(stack, this.properties);
        this.values.clear();
        this.properties.forEach((name, property) -> this.values.put((BlockProperty<?>)property, property.getValue(stack)));
        return this;
    }

    @Override
    public BlockStateImpl clone() {
        return POOL.getInstance().copy(this);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public <T> T getPropertyValue(BlockProperty<T> property) {
        return (T)this.values.get(property);
    }

    @Override
    public <T> T getPropertyValue(String name) {
        BlockProperty<?> property = this.properties.get(name);
        if (property == null) {
            return null;
        }
        return (T)this.values.get(property);
    }

    @Override
    public <T> void setPropertyValue(BlockProperty<T> property, T value) {
        if (this.properties.containsValue(property)) {
            this.values.put(property, value);
        }
    }

    @Override
    public <T> void setPropertyValue(String name, T value) {
        Class clazz;
        BlockProperty<?> property = this.properties.get(name);
        if (property == null) {
            GTNHLib.LOG.warn("Tried to set invalid property on BlockState by name. Name={}, Value={}", new Object[]{name, value, new Exception()});
            return;
        }
        Type type = property.getType();
        if (type instanceof Class && !(clazz = (Class)type).isInstance(value)) {
            GTNHLib.LOG.warn("Tried to set value for property on BlockState to an incompatible value. Name={}, Value={}", new Object[]{name, value, new Exception()});
            return;
        }
        this.values.put(property, value);
    }

    @Override
    public Map<String, String> toMap() {
        Object2ObjectOpenHashMap<String, String> out = new Object2ObjectOpenHashMap<String, String>(this.values.size());
        this.properties.forEach((name, prop) -> {
            Object value = this.values.get(prop);
            if (value != null) {
                out.put((String)name, prop.stringify(value));
            }
        });
        return out;
    }

    @Override
    public void transform(TransformLike transform) {
        this.values.replaceAll((property, value) -> {
            if (property.hasTrait(BlockPropertyTrait.VectorTransformable) && transform instanceof VectorTransform) {
                VectorTransform vector = (VectorTransform)transform;
                return ((VectorTransformableProperty)property).transform(value, vector);
            }
            if (property.hasTrait(BlockPropertyTrait.Transformable) && transform instanceof DirectionTransform) {
                DirectionTransform dir = (DirectionTransform)transform;
                return ((TransformableProperty)property).transform(value, dir);
            }
            return value;
        });
    }

    @Override
    public void place(World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, this.block, this.meta, 2);
        this.values.forEach((property, value) -> {
            if (property.hasTrait(BlockPropertyTrait.SupportsWorld) && property.hasTrait(BlockPropertyTrait.WorldMutable)) {
                property.setValue(world, x, y, z, value);
            }
        });
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack(this.block, 1, this.block.func_149692_a(this.meta));
        this.values.forEach((property, value) -> {
            if (property.hasTrait(BlockPropertyTrait.SupportsStacks) && property.hasTrait(BlockPropertyTrait.StackMutable)) {
                property.setValue(stack, value);
            }
        });
        return stack;
    }

    @Override
    public void close() {
        POOL.releaseInstance(this.reset());
    }
}

