/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.init;

import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import com.gtnewhorizon.gtnhlib.blockstate.core.InvalidPropertyTextException;
import com.gtnewhorizon.gtnhlib.blockstate.core.MetaBlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.TransformableProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.VectorTransformableProperty;
import com.gtnewhorizon.gtnhlib.blockstate.mixin.BlockSkullExt;
import com.gtnewhorizon.gtnhlib.blockstate.properties.AxisBlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.properties.BooleanBlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.properties.DirectionBlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.properties.FloatBlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.properties.IntegerBlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.registry.BlockPropertyRegistry;
import com.gtnewhorizon.gtnhlib.geometry.Axis;
import com.gtnewhorizon.gtnhlib.geometry.DirectionTransform;
import com.gtnewhorizon.gtnhlib.geometry.VectorTransform;
import java.lang.reflect.Type;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

class VanillaBlockProperties {
    VanillaBlockProperties() {
    }

    static void initVanilla() {
        BlockPropertyRegistry.registerProperty(BlockRotatedPillar.class, AxisBlockProperty.axis(12, axis -> {
            int n;
            switch (axis) {
                case X: {
                    n = 4;
                    break;
                }
                case Z: {
                    n = 8;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            Axis axis;
            switch (meta) {
                case 4: {
                    axis = Axis.X;
                    break;
                }
                case 8: {
                    axis = Axis.Z;
                    break;
                }
                default: {
                    axis = Axis.Y;
                }
            }
            return axis;
        }));
        BlockPropertyRegistry.registerProperty(BlockQuartz.class, new AxisBlockProperty.AbstractAxisBlockProperty("axis"){

            @Override
            public boolean appliesTo(IBlockAccess world, int x, int y, int z, Block block, int meta, @Nullable TileEntity tile) {
                return meta >= 2 && meta <= 4;
            }

            @Override
            public int getMeta(Axis value, int existing) {
                int n;
                if (existing < 2 || existing > 4) {
                    return existing;
                }
                switch (value) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        n = 3;
                        break;
                    }
                    case Y: {
                        n = 2;
                        break;
                    }
                    case Z: {
                        n = 4;
                        break;
                    }
                    case UNKNOWN: {
                        n = 2;
                    }
                }
                return n;
            }

            @Override
            public Axis getValue(int meta) {
                Axis axis;
                switch (meta) {
                    case 3: {
                        axis = Axis.X;
                        break;
                    }
                    case 2: {
                        axis = Axis.Y;
                        break;
                    }
                    case 4: {
                        axis = Axis.Z;
                        break;
                    }
                    default: {
                        axis = Axis.UNKNOWN;
                    }
                }
                return axis;
            }
        });
        class RailModeProperty
        implements MetaBlockProperty<RailMode> {
            private final boolean canTurn;

            public RailModeProperty(boolean canTurn) {
                this.canTurn = canTurn;
            }

            @Override
            public String getName() {
                return "mode";
            }

            @Override
            public Type getType() {
                return RailMode.class;
            }

            @Override
            public boolean hasTrait(BlockPropertyTrait trait) {
                boolean bl;
                switch (trait) {
                    case SupportsWorld: 
                    case OnlyNeedsMeta: 
                    case WorldMutable: 
                    case Config: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public RailMode getValue(int meta) {
                return VanillaBlockProperties.getRailMode(meta, this.canTurn);
            }

            @Override
            public int getMeta(RailMode value, int existing) {
                return VanillaBlockProperties.getRailMeta(value, VanillaBlockProperties.getRailDirection(existing, this.canTurn), this.canTurn, false);
            }

            @Override
            public String stringify(RailMode value) {
                return value.toString();
            }

            @Override
            public RailMode parse(String text) throws InvalidPropertyTextException {
                return RailMode.parse(text);
            }
        }
        BlockPropertyRegistry.registerProperty(Blocks.field_150448_aq, new RailModeProperty(true));
        BlockPropertyRegistry.registerProperty(Blocks.field_150448_aq, DirectionBlockProperty.facing((dir, existing) -> VanillaBlockProperties.getRailMeta(VanillaBlockProperties.getRailMode(existing, true), dir, true, false), meta -> VanillaBlockProperties.getRailDirection(meta, true)));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc), new RailModeProperty(false));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc), DirectionBlockProperty.facing((dir, existing) -> VanillaBlockProperties.getRailMeta(VanillaBlockProperties.getRailMode(existing, false), dir, false, VanillaBlockProperties.isRailPowered(existing)), meta -> VanillaBlockProperties.getRailDirection(meta, false)));
        BooleanBlockProperty.FlagBooleanBlockProperty powered = BooleanBlockProperty.flag("powered", 8);
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150408_cc), powered);
        BlockPropertyRegistry.registerProperty(BlockButton.class, powered);
        BlockPropertyRegistry.registerProperty(BlockButton.class, DirectionBlockProperty.facing(7, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerProperty(BlockTorch.class, DirectionBlockProperty.facing(-1, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerProperty(Blocks.field_150429_aA, BooleanBlockProperty.blocks("powered", Blocks.field_150437_az, Blocks.field_150429_aA));
        BlockPropertyRegistry.registerProperty(Blocks.field_150437_az, BooleanBlockProperty.blocks("powered", Blocks.field_150437_az, Blocks.field_150429_aA));
        BlockPropertyRegistry.registerProperty(Blocks.field_150442_at, powered);
        BlockPropertyRegistry.registerProperty(Blocks.field_150442_at, new AxisBlockProperty.Meta(){
            private static final int CEILING_X = 0;
            private static final int CEILING_Z = 7;
            private static final int FLOOR_X = 6;
            private static final int FLOOR_Z = 5;

            @Override
            public boolean hasTrait(BlockPropertyTrait trait) {
                boolean bl;
                switch (trait) {
                    case SupportsWorld: 
                    case OnlyNeedsMeta: 
                    case WorldMutable: 
                    case Config: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public boolean isValidAxis(Axis value) {
                return value == Axis.X || value == Axis.Z;
            }

            @Override
            public Axis getValue(int meta) {
                Axis axis;
                switch (meta & 7) {
                    case 0: 
                    case 6: {
                        axis = Axis.X;
                        break;
                    }
                    case 5: 
                    case 7: {
                        axis = Axis.Z;
                        break;
                    }
                    default: {
                        axis = Axis.UNKNOWN;
                    }
                }
                return axis;
            }

            @Override
            public int getMeta(Axis value, int meta) {
                int power = meta & 8;
                boolean ceiling = (meta &= 7) == 0 || meta == 7;
                switch (this.getValue(meta)) {
                    case X: {
                        meta = ceiling ? 0 : 6;
                        break;
                    }
                    case Z: {
                        meta = ceiling ? 7 : 5;
                    }
                }
                return meta | power;
            }
        });
        BlockPropertyRegistry.registerProperty(Blocks.field_150442_at, DirectionBlockProperty.facing((dir, existing) -> {
            int n;
            switch (dir) {
                case NORTH: {
                    n = 3;
                    break;
                }
                case SOUTH: {
                    n = 4;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case EAST: {
                    n = 2;
                    break;
                }
                case UP: {
                    if ((existing & 7) == 7) {
                        n = 7;
                        break;
                    }
                    n = 0;
                    break;
                }
                case DOWN: {
                    if ((existing & 7) == 6) {
                        n = 6;
                        break;
                    }
                    n = 5;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return existing & 8 | n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta & 7) {
                case 3: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case 4: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 0: 
                case 7: {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                case 5: 
                case 6: {
                    forgeDirection = ForgeDirection.DOWN;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.UNKNOWN;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerProperty(BlockPistonBase.class, powered);
        BlockPropertyRegistry.registerProperty(BlockPistonBase.class, DirectionBlockProperty.facing(7, 3, 4, 1, 2, 0, 5));
        BlockPropertyRegistry.registerProperty(BlockPistonExtension.class, DirectionBlockProperty.facing(7, 3, 4, 1, 2, 0, 5));
        class SlabTopProperty
        extends BooleanBlockProperty.FlagBooleanBlockProperty
        implements TransformableProperty<Boolean> {
            public SlabTopProperty() {
                super("top", 8);
            }

            @Override
            public boolean hasTrait(BlockPropertyTrait trait) {
                boolean bl;
                switch (trait) {
                    case SupportsWorld: 
                    case OnlyNeedsMeta: 
                    case WorldMutable: 
                    case Config: 
                    case Transformable: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            @NotNull
            public Boolean transform(Boolean value, DirectionTransform transform) {
                ForgeDirection dir = (ForgeDirection)transform.apply(value != false ? ForgeDirection.UP : ForgeDirection.DOWN);
                if (dir == ForgeDirection.UP) {
                    return true;
                }
                if (dir == ForgeDirection.DOWN) {
                    return false;
                }
                return value;
            }

            @Override
            public boolean appliesTo(IBlockAccess world, int x, int y, int z, Block block, int meta, @Nullable TileEntity tile) {
                BlockSlab slab;
                return block instanceof BlockSlab && !(slab = (BlockSlab)block).func_149662_c();
            }
        }
        BlockPropertyRegistry.registerProperty(BlockSlab.class, new SlabTopProperty());
        BlockPropertyRegistry.registerProperty(BlockStairs.class, DirectionBlockProperty.facing(3, dir -> {
            int n;
            switch (dir) {
                case EAST: {
                    n = 0;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case SOUTH: {
                    n = 2;
                    break;
                }
                case NORTH: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 0: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.NORTH;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerProperty(BlockStairs.class, DirectionBlockProperty.facing(4, dir -> {
            int n;
            switch (dir) {
                case UP: {
                    n = 0;
                    break;
                }
                case DOWN: {
                    n = 4;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 0: {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                case 4: {
                    forgeDirection = ForgeDirection.DOWN;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.UP;
                }
            }
            return forgeDirection;
        }).setName("up"));
        BlockPropertyRegistry.registerProperty(BlockChest.class, DirectionBlockProperty.facing(7, 2, 3, 4, 5, -1, -1));
        BlockPropertyRegistry.registerProperty(BlockAnvil.class, DirectionBlockProperty.facing(3, dir -> {
            int n;
            switch (dir) {
                case WEST: {
                    n = 0;
                    break;
                }
                case NORTH: {
                    n = 1;
                    break;
                }
                case EAST: {
                    n = 2;
                    break;
                }
                case SOUTH: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 0: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 3: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.NORTH;
                }
            }
            return forgeDirection;
        }));
        BlockPropertyRegistry.registerProperty(BlockAnvil.class, IntegerBlockProperty.meta("damage", 12, 2).map(Arrays.asList("undamaged", "slightly_damaged", "very_damaged", "broken")));
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150488_af, IntegerBlockProperty.meta("power", 15, 0));
        BlockPropertyRegistry.registerProperty(BlockFurnace.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerProperty(BlockFurnace.class, BooleanBlockProperty.blocks("lit", Blocks.field_150460_al, Blocks.field_150470_am));
        BlockPropertyRegistry.registerProperty(Blocks.field_150444_as, DirectionBlockProperty.facing());
        class StandingSignRotationProperty
        implements FloatBlockProperty,
        MetaBlockProperty<Float>,
        VectorTransformableProperty<Float> {
            StandingSignRotationProperty() {
            }

            @Override
            public String getName() {
                return "rotation";
            }

            @Override
            public boolean hasTrait(BlockPropertyTrait trait) {
                boolean bl;
                switch (trait) {
                    case SupportsWorld: 
                    case OnlyNeedsMeta: 
                    case WorldMutable: 
                    case Config: 
                    case VectorTransformable: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public boolean needsExisting() {
                return false;
            }

            @Override
            public int getMeta(Float value, int existing) {
                return (Math.round(value.floatValue() * 16.0f / 360.0f) % 16 + 16) % 16;
            }

            @Override
            public Float getValue(int meta) {
                return Float.valueOf((float)meta * 360.0f / 16.0f);
            }

            @Override
            @NotNull
            public Float transform(Float value, VectorTransform transform) {
                Vector3f v = new Vector3f(0.0f, 0.0f, 1.0f).rotateAxis(value.floatValue() * (float)Math.PI * 2.0f / 360.0f, 0.0f, 1.0f, 0.0f);
                transform.transform(v);
                float rotation = MathHelper.func_76128_c((double)(Math.atan2(v.x, v.z) * 360.0 / Math.PI / 2.0 + 0.5));
                rotation = (rotation % 360.0f + 360.0f) % 360.0f;
                return Float.valueOf(rotation);
            }
        }
        BlockPropertyRegistry.registerProperty(Blocks.field_150472_an, new StandingSignRotationProperty());
        BlockPropertyRegistry.registerProperty(TileEntitySign.class, new BlockProperty<String>(){

            @Override
            public String getName() {
                return "text";
            }

            @Override
            public Type getType() {
                return String.class;
            }

            @Override
            public boolean hasTrait(BlockPropertyTrait trait) {
                boolean bl;
                switch (trait) {
                    case SupportsWorld: 
                    case WorldMutable: 
                    case Config: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public boolean appliesTo(IBlockAccess world, int x, int y, int z, Block block, int meta, @Nullable TileEntity tile) {
                return tile instanceof TileEntitySign;
            }

            @Override
            public String getValue(IBlockAccess world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySign)) {
                    return "";
                }
                TileEntitySign sign = (TileEntitySign)tileEntity;
                return String.join((CharSequence)"\n", sign.field_145915_a);
            }

            @Override
            public void setValue(World world, int x, int y, int z, String value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntitySign)) {
                    return;
                }
                TileEntitySign sign = (TileEntitySign)tileEntity;
                String[] text = value.split("\n");
                sign.field_145915_a = new String[4];
                for (int i = 0; i < 4; ++i) {
                    String line = BlockProperty.getIndexSafe(text, i);
                    if (line == null) {
                        line = "";
                    }
                    if (line.length() > 15) {
                        line = line.substring(0, 15);
                    }
                    sign.field_145915_a[i] = line;
                }
                sign.func_70296_d();
                world.func_147471_g(x, y, z);
            }

            @Override
            public String stringify(String value) {
                return value;
            }

            @Override
            public String parse(String text) {
                return text;
            }
        });
        BlockPropertyRegistry.registerProperty(BlockDoor.class, new DirectionBlockProperty(){

            @Override
            public String getName() {
                return "facing";
            }

            @Override
            public boolean hasTrait(BlockPropertyTrait trait) {
                boolean bl;
                switch (trait) {
                    case SupportsWorld: 
                    case WorldMutable: 
                    case Config: 
                    case Transformable: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public boolean isValidDirection(ForgeDirection value) {
                return value.offsetY == 0;
            }

            @Override
            public ForgeDirection getValue(IBlockAccess world, int x, int y, int z) {
                ForgeDirection forgeDirection;
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return ForgeDirection.UNKNOWN;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                switch (meta & 3) {
                    case 0: {
                        forgeDirection = ForgeDirection.WEST;
                        break;
                    }
                    case 1: {
                        forgeDirection = ForgeDirection.NORTH;
                        break;
                    }
                    case 2: {
                        forgeDirection = ForgeDirection.EAST;
                        break;
                    }
                    case 3: {
                        forgeDirection = ForgeDirection.SOUTH;
                        break;
                    }
                    default: {
                        forgeDirection = ForgeDirection.NORTH;
                    }
                }
                return forgeDirection;
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                int n;
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                meta &= 0xFFFFFFFC;
                switch (value) {
                    case WEST: {
                        n = 0;
                        break;
                    }
                    case NORTH: {
                        n = 1;
                        break;
                    }
                    case EAST: {
                        n = 2;
                        break;
                    }
                    case SOUTH: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 1;
                    }
                }
                world.func_72921_c(x, y, z, meta |= n, 2);
            }
        });
        BlockPropertyRegistry.registerProperty(BlockDoor.class, new BooleanBlockProperty(){

            @Override
            public String getName() {
                return "open";
            }

            @Override
            public boolean hasTrait(BlockPropertyTrait trait) {
                boolean bl;
                switch (trait) {
                    case SupportsWorld: 
                    case WorldMutable: 
                    case Config: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public Boolean getValue(IBlockAccess world, int x, int y, int z) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return false;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                return meta >= 4;
            }

            @Override
            public void setValue(World world, int x, int y, int z, Boolean value) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 8) {
                    if (!(world.func_147439_a(x, --y, z) instanceof BlockDoor)) {
                        return;
                    }
                    meta = world.func_72805_g(x, y, z);
                }
                meta &= 0xFFFFFFFB;
                if (value.booleanValue()) {
                    meta |= 4;
                }
                world.func_72921_c(x, y, z, meta, 2);
            }
        });
        BlockPropertyRegistry.registerProperty(BlockLadder.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerProperty(BlockBasePressurePlate.class, BooleanBlockProperty.flag("powered", 1));
        BlockPropertyRegistry.registerProperty(BlockPumpkin.class, DirectionBlockProperty.facing(3, 2, 0, 1, 3, -1, -1));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150413_aR, Blocks.field_150416_aS), BooleanBlockProperty.blocks("powered", (Block)Blocks.field_150413_aR, (Block)Blocks.field_150416_aS));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150413_aR, Blocks.field_150416_aS), DirectionBlockProperty.facing(3, 0, 2, 3, 1, -1, -1));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150413_aR, Blocks.field_150416_aS), IntegerBlockProperty.meta("delay", 12, 2));
        BlockPropertyRegistry.registerProperty(BlockTrapDoor.class, DirectionBlockProperty.facing(3, 0, 1, 2, 3, -1, -1));
        BlockPropertyRegistry.registerProperty(BlockTrapDoor.class, BooleanBlockProperty.flag("open", 4));
        BlockPropertyRegistry.registerProperty(BlockTrapDoor.class, DirectionBlockProperty.facing(8, -1, -1, -1, -1, 8, 0).setName("up"));
        BlockPropertyRegistry.registerProperty(BlockRedstoneLight.class, BooleanBlockProperty.blocks("powered", Blocks.field_150379_bu, Blocks.field_150374_bv));
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150479_bC, DirectionBlockProperty.facing(3, 0, 2, 3, 1, -1, -1));
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150479_bC, powered);
        BlockPropertyRegistry.registerProperty((Block)Blocks.field_150479_bC, BooleanBlockProperty.flag("connected", 4));
        class SkullRotationProperty
        implements IntegerBlockProperty,
        VectorTransformableProperty<Integer> {
            SkullRotationProperty() {
            }

            @Override
            public String getName() {
                return "rotation";
            }

            @Override
            public boolean hasTrait(BlockPropertyTrait trait) {
                boolean bl;
                switch (trait) {
                    case SupportsWorld: 
                    case WorldMutable: 
                    case Config: 
                    case VectorTransformable: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public Integer getValue(IBlockAccess world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof BlockSkullExt)) {
                    return 0;
                }
                BlockSkullExt skull = (BlockSkullExt)tileEntity;
                return skull.gtnhlib$getRotation() * 360 / 16;
            }

            @Override
            public void setValue(World world, int x, int y, int z, Integer value) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof BlockSkullExt)) {
                    return;
                }
                BlockSkullExt skull = (BlockSkullExt)tileEntity;
                skull.gtnhlib$setRotation(value * 16 / 360);
                world.func_147471_g(x, y, z);
            }

            @Override
            @NotNull
            public Integer transform(Integer value, VectorTransform transform) {
                Vector3f v = new Vector3f(0.0f, 0.0f, 1.0f).rotateAxis((float)value.intValue() * (float)Math.PI * 2.0f / 360.0f, 0.0f, 1.0f, 0.0f);
                transform.transform(v);
                int rotation = MathHelper.func_76128_c((double)(Math.atan2(v.x, v.z) * 360.0 / Math.PI / 2.0 + 0.5));
                return (rotation % 360 + 360) % 360;
            }
        }
        BlockPropertyRegistry.registerProperty(TileEntitySkull.class, new SkullRotationProperty());
        BlockPropertyRegistry.registerProperty(BlockDispenser.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150441_bU, Blocks.field_150455_bV), BooleanBlockProperty.flag("powered", 8));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150441_bU, Blocks.field_150455_bV), DirectionBlockProperty.facing(3, 0, 2, 3, 1, -1, -1));
        BlockPropertyRegistry.registerProperty(Arrays.asList(Blocks.field_150441_bU, Blocks.field_150455_bV), IntegerBlockProperty.meta("mode", 4, 2).map(Arrays.asList("comparator", "subtractor")));
        BlockPropertyRegistry.registerProperty(BlockHopper.class, DirectionBlockProperty.facing());
        BlockPropertyRegistry.registerProperty(BlockFenceGate.class, DirectionBlockProperty.facing(3, 2, 0, 1, 3, -1, -1));
        BlockPropertyRegistry.registerProperty(BlockFenceGate.class, BooleanBlockProperty.flag("open", 4));
    }

    private static RailMode getRailMode(int meta, boolean canTurn) {
        return canTurn && meta >= 6 ? RailMode.TURNED : (meta >= 2 ? RailMode.ASCENDING : RailMode.NONE);
    }

    private static ForgeDirection getRailDirection(int meta, boolean canTurn) {
        ForgeDirection forgeDirection;
        if (canTurn) {
            ForgeDirection forgeDirection2;
            switch (meta) {
                case 0: 
                case 4: 
                case 6: {
                    forgeDirection2 = ForgeDirection.NORTH;
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    forgeDirection2 = ForgeDirection.WEST;
                    break;
                }
                case 2: 
                case 7: {
                    forgeDirection2 = ForgeDirection.EAST;
                    break;
                }
                case 5: 
                case 8: {
                    forgeDirection2 = ForgeDirection.SOUTH;
                    break;
                }
                default: {
                    forgeDirection2 = ForgeDirection.NORTH;
                }
            }
            return forgeDirection2;
        }
        switch (meta) {
            case 0: 
            case 4: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case 1: 
            case 3: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case 2: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case 5: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.NORTH;
            }
        }
        return forgeDirection;
    }

    private static boolean isRailPowered(int meta) {
        return meta >= 8;
    }

    private static int getRailMeta(RailMode mode, ForgeDirection dir, boolean canTurn, boolean powered) {
        int n;
        if (canTurn && mode == RailMode.TURNED) {
            int n2;
            switch (dir) {
                case NORTH: {
                    n2 = 6;
                    break;
                }
                case WEST: {
                    n2 = 9;
                    break;
                }
                case EAST: {
                    n2 = 7;
                    break;
                }
                case SOUTH: {
                    n2 = 8;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            return n2;
        }
        if (mode == RailMode.ASCENDING) {
            int n3;
            switch (dir) {
                case NORTH: {
                    n3 = 4;
                    break;
                }
                case WEST: {
                    n3 = 3;
                    break;
                }
                case EAST: {
                    n3 = 2;
                    break;
                }
                case SOUTH: {
                    n3 = 5;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            return n3;
        }
        switch (dir) {
            case NORTH: 
            case SOUTH: {
                n = 0;
                break;
            }
            case WEST: 
            case EAST: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static enum RailMode {
        NONE,
        ASCENDING,
        TURNED;


        public String toString() {
            String string;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    string = "none";
                    break;
                }
                case ASCENDING: {
                    string = "ascending";
                    break;
                }
                case TURNED: {
                    string = "turned";
                }
            }
            return string;
        }

        public static RailMode parse(String name) throws InvalidPropertyTextException {
            if ("turned".equals(name)) {
                return TURNED;
            }
            if ("ascending".equals(name)) {
                return ASCENDING;
            }
            if ("none".equals(name)) {
                return NONE;
            }
            throw new InvalidPropertyTextException("Illegal rail mode: '" + name + "'");
        }
    }
}

