/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.properties;

import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import com.gtnewhorizon.gtnhlib.blockstate.core.MetaBlockProperty;
import com.gtnewhorizon.gtnhlib.util.data.BlockSupplier;
import java.lang.reflect.Type;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public interface BooleanBlockProperty
extends BlockProperty<Boolean> {
    @Override
    default public Type getType() {
        return Boolean.TYPE;
    }

    public static FlagBooleanBlockProperty flag(String name, int flag) {
        return new FlagBooleanBlockProperty(name, flag);
    }

    public static BooleanBlockProperty blocks(String name, Block falsey, Block truthy) {
        return BooleanBlockProperty.blocks(name, () -> falsey, () -> truthy);
    }

    public static BooleanBlockProperty blocks(final String name, final BlockSupplier falsey, final BlockSupplier truthy) {
        return new BooleanBlockProperty(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean hasTrait(BlockPropertyTrait trait) {
                boolean bl;
                switch (trait) {
                    case SupportsWorld: 
                    case SupportsStacks: 
                    case WorldMutable: 
                    case StackMutable: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public Boolean getValue(IBlockAccess world, int x, int y, int z) {
                return world.func_147439_a(x, y, z) == truthy.get();
            }

            @Override
            public void setValue(World world, int x, int y, int z, Boolean value) {
                world.func_147465_d(x, y, z, value != false ? (Block)truthy.get() : (Block)falsey.get(), world.func_72805_g(x, y, z), 2);
            }

            @Override
            public Boolean getValue(ItemStack stack) {
                return ((ItemBlock)stack.func_77973_b()).field_150939_a == truthy.get();
            }

            @Override
            public void setValue(ItemStack stack, Boolean value) {
                stack.func_150996_a(Item.func_150898_a((Block)(value != false ? (Block)truthy.get() : (Block)falsey.get())));
            }
        };
    }

    public static class FlagBooleanBlockProperty
    implements BooleanBlockProperty,
    MetaBlockProperty<Boolean> {
        public final String name;
        public final int flag;

        public FlagBooleanBlockProperty(String name, int flag) {
            this.name = name;
            this.flag = flag;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasTrait(BlockPropertyTrait trait) {
            boolean bl;
            switch (trait) {
                case SupportsWorld: 
                case SupportsStacks: 
                case OnlyNeedsMeta: 
                case WorldMutable: 
                case StackMutable: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public int getMeta(Boolean value, int existing) {
            existing &= ~this.flag;
            if (value.booleanValue()) {
                existing |= this.flag;
            }
            return existing;
        }

        @Override
        public Boolean getValue(int meta) {
            return (meta & this.flag) == this.flag;
        }
    }
}

