/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import com.gtnewhorizon.gtnhlib.blockstate.core.InvalidPropertyTextException;
import com.gtnewhorizon.gtnhlib.blockstate.core.MetaBlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.TransformableProperty;
import com.gtnewhorizon.gtnhlib.geometry.DirectionTransform;
import com.gtnewhorizon.gtnhlib.geometry.Orientation;
import java.lang.reflect.Type;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public interface OrientationBlockProperty
extends BlockProperty<Orientation>,
TransformableProperty<Orientation> {
    @Override
    default public String getName() {
        return "orientation";
    }

    @Override
    default public Type getType() {
        return Orientation.class;
    }

    @Override
    default public JsonElement serialize(Orientation value) {
        return new JsonPrimitive(this.stringify(value));
    }

    @Override
    default public Orientation deserialize(JsonElement element) {
        return element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() ? this.parse(element.getAsString()) : Orientation.UNKNOWN;
    }

    @Override
    default public String stringify(Orientation value) {
        return value.name().toLowerCase();
    }

    @Override
    default public Orientation parse(String text) throws InvalidPropertyTextException {
        try {
            return Orientation.valueOf(text.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPropertyTextException("Invalid Orientation", e);
        }
    }

    @Override
    @NotNull
    default public Orientation transform(Orientation value, DirectionTransform transform) {
        ForgeDirection b;
        ForgeDirection a = (ForgeDirection)transform.apply(value.a);
        Orientation transformed = Orientation.getOrientation(a, b = (ForgeDirection)transform.apply(value.b));
        return this.isValidOrientation(transformed) ? transformed : value;
    }

    default public boolean isValidOrientation(Orientation value) {
        return true;
    }

    public static OrientationBlockProperty orientation(int mask, O2M o2m, M2O m2o) {
        return new MetaOrientationBlockProperty(m2o, mask, o2m);
    }

    public static class MetaOrientationBlockProperty
    implements OrientationBlockProperty,
    MetaBlockProperty<Orientation> {
        private final M2O m2o;
        private final int mask;
        private final O2M o2m;

        public MetaOrientationBlockProperty(M2O m2o, int mask, O2M o2m) {
            this.m2o = m2o;
            this.mask = mask;
            this.o2m = o2m;
        }

        @Override
        public boolean needsExisting() {
            return this.mask != -1;
        }

        @Override
        public int getMeta(Orientation value, int existing) {
            return this.o2m.getMeta(value) | existing & ~this.mask;
        }

        @Override
        public Orientation getValue(int meta) {
            return this.m2o.getDir(meta & this.mask);
        }

        @Override
        public boolean hasTrait(BlockPropertyTrait trait) {
            boolean bl;
            switch (trait) {
                case SupportsWorld: 
                case OnlyNeedsMeta: 
                case WorldMutable: 
                case Config: 
                case Transformable: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }

    public static interface M2O {
        public Orientation getDir(int var1);
    }

    public static interface O2M {
        public int getMeta(Orientation var1);
    }
}

