/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.DrawCallback;
import com.gtnewhorizon.gtnhlib.client.renderer.ITessellatorInstance;
import com.gtnewhorizon.gtnhlib.client.renderer.PrimitiveExtractor;
import com.gtnewhorizon.gtnhlib.client.renderer.QuadExtractor;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.line.ModelLine;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.primitive.ModelPrimitiveView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuad;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.tri.ModelTriangle;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VAOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.Tessellator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;

public class TessellatorManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"TessellatorManager");
    private static final ThreadLocal<CapturingTessellator> capturingTessellator = ThreadLocal.withInitial(CapturingTessellator::new);
    private static final ThreadLocal<ArrayList<CaptureState>> captureStack = ThreadLocal.withInitial(ArrayList::new);
    private static final Thread mainThread = Thread.currentThread();
    private static boolean isInCompilingCallback = false;
    private static final int EXPECTED_PRIMITIVE_VERTEX_SIZE = 32;

    public static Tessellator get() {
        ArrayList<CaptureState> stack = captureStack.get();
        if (!stack.isEmpty()) {
            return capturingTessellator.get();
        }
        if (TessellatorManager.isOnMainThread()) {
            return Tessellator.field_78398_a;
        }
        throw new IllegalStateException("Tried to get the Tessellator off the main thread when not capturing!");
    }

    public static boolean isCurrentlyCapturing() {
        CaptureState current = TessellatorManager.peekState();
        return current != null && current.mode == CaptureMode.CAPTURING;
    }

    static boolean isCurrentlyCompiling() {
        CaptureState current = TessellatorManager.peekState();
        return current != null && current.mode == CaptureMode.COMPILING;
    }

    public static boolean isOnMainThread() {
        return Thread.currentThread() == mainThread;
    }

    public static boolean isMainInstance(Object instance) {
        return instance == Tessellator.field_78398_a || TessellatorManager.isOnMainThread();
    }

    private static CaptureState peekState() {
        ArrayList<CaptureState> stack = captureStack.get();
        return stack.isEmpty() ? null : stack.get(stack.size() - 1);
    }

    private static CaptureState requireMode(CaptureMode expected, String errorMsg) {
        ArrayList<CaptureState> stack = captureStack.get();
        if (stack.isEmpty() || stack.get((int)(stack.size() - 1)).mode != expected) {
            throw new IllegalStateException(errorMsg);
        }
        return stack.get(stack.size() - 1);
    }

    private static void setVanillaTessellatorCompiling(boolean compiling) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (tessellator instanceof ITessellatorInstance) {
            ITessellatorInstance tessInst = (ITessellatorInstance)tessellator;
            tessInst.gtnhlib$setCompiling(compiling);
        }
    }

    private static boolean hasCompilingInStack(ArrayList<CaptureState> stack) {
        for (int i = stack.size() - 1; i >= 0; --i) {
            if (stack.get((int)i).mode != CaptureMode.COMPILING) continue;
            return true;
        }
        return false;
    }

    private static void saveParentQuadsIfNeeded(ArrayList<CaptureState> stack, CapturingTessellator tess) {
        if (stack.isEmpty()) {
            return;
        }
        CaptureState parent = stack.get(stack.size() - 1);
        if (parent.mode == CaptureMode.CAPTURING) {
            parent.savedQuads = new ArrayList<ModelQuadViewMutable>(tess.getQuads());
            tess.getQuads().clear();
        }
    }

    public static void startCapturing() {
        TessellatorManager.startCapturingAndGet();
    }

    public static CapturingTessellator startCapturingAndGet() {
        ArrayList<CaptureState> stack = captureStack.get();
        CapturingTessellator tess = capturingTessellator.get();
        TessellatorManager.saveParentQuadsIfNeeded(stack, tess);
        if (!tess.getQuads().isEmpty()) {
            throw new IllegalStateException("Tried to start capturing with existing collected Quads!");
        }
        tess.storeTranslation();
        stack.add(new CaptureState(CaptureMode.CAPTURING, null));
        return tess;
    }

    public static List<ModelQuadViewMutable> stopCapturingToPooledQuads() {
        List<ModelQuadViewMutable> quads;
        boolean isNested;
        CaptureState currentState = TessellatorManager.requireMode(CaptureMode.CAPTURING, "Tried to stop capturing when not capturing!");
        ArrayList<CaptureState> stack = captureStack.get();
        CapturingTessellator tess = capturingTessellator.get();
        if (tess.field_78415_z) {
            tess.func_78381_a();
        }
        stack.remove(stack.size() - 1);
        tess.restoreTranslation();
        boolean bl = isNested = !stack.isEmpty() && stack.get((int)(stack.size() - 1)).mode == CaptureMode.CAPTURING;
        if (currentState.savedQuads != null) {
            quads = currentState.savedQuads;
            quads.addAll(tess.getQuads());
            tess.getQuads().clear();
        } else if (isNested) {
            quads = new ArrayList<ModelQuadViewMutable>(tess.getQuads());
            tess.getQuads().clear();
        } else {
            quads = tess.getQuads();
        }
        return quads;
    }

    public static ByteBuffer stopCapturingToBuffer(VertexFormat format) {
        ByteBuffer buf = CapturingTessellator.quadsToBuffer(TessellatorManager.stopCapturingToPooledQuads(), format);
        capturingTessellator.get().clearQuads();
        return buf;
    }

    public static VertexBuffer stopCapturingToVBO(VertexFormat format) {
        return new VertexBuffer(format, 7).upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static CapturedGeometry stopCapturingToGeometry(VertexFormat format) {
        CaptureState currentState = TessellatorManager.requireMode(CaptureMode.CAPTURING, "Tried to stop capturing when not capturing!");
        ArrayList<CaptureState> stack = captureStack.get();
        CapturingTessellator tess = capturingTessellator.get();
        if (tess.field_78415_z) {
            tess.func_78381_a();
        }
        stack.remove(stack.size() - 1);
        tess.restoreTranslation();
        List<ModelLine> lines = tess.lineListCache;
        List<ModelTriangle> triangles = tess.triangleListCache;
        List<ModelQuad> quads = tess.quadListCache;
        lines.clear();
        triangles.clear();
        quads.clear();
        List<ModelPrimitiveView> prims = tess.getPrimitives();
        int size = prims.size();
        for (int i = 0; i < size; ++i) {
            ModelPrimitiveView prim = prims.get(i);
            if (prim instanceof ModelLine) {
                ModelLine ml = (ModelLine)prim;
                lines.add(ml);
                continue;
            }
            if (!(prim instanceof ModelTriangle)) continue;
            ModelTriangle mt = (ModelTriangle)prim;
            triangles.add(mt);
        }
        List<ModelQuadViewMutable> collectedQuads = tess.getQuads();
        int size2 = collectedQuads.size();
        for (int i = 0; i < size2; ++i) {
            ModelQuadViewMutable quad = collectedQuads.get(i);
            if (!(quad instanceof ModelQuad)) continue;
            ModelQuad mq = (ModelQuad)quad;
            quads.add(mq);
        }
        ArrayList<VertexBuffer> vbos = new ArrayList<VertexBuffer>();
        if (!lines.isEmpty()) {
            vbos.add(TessellatorManager.createLineVBO(lines, format));
        }
        if (!triangles.isEmpty()) {
            vbos.add(TessellatorManager.createTriangleVBO(triangles, format));
        }
        if (!quads.isEmpty()) {
            vbos.add(TessellatorManager.createQuadVBO(quads, format));
        }
        tess.clearPrimitives();
        tess.clearQuads();
        if (stack.isEmpty() || stack.get((int)(stack.size() - 1)).mode != CaptureMode.CAPTURING) {
            tess.discard();
        }
        return new CapturedGeometry(vbos);
    }

    private static VertexBuffer createLineVBO(List<ModelLine> lines, VertexFormat format) {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(format.getVertexSize() * lines.size() * 2));
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            TessellatorManager.writePrimitiveToBuffer(lines.get(i), buffer, format);
        }
        buffer.rewind();
        return new VertexBuffer(format, 1).upload(buffer);
    }

    private static VertexBuffer createTriangleVBO(List<ModelTriangle> triangles, VertexFormat format) {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(format.getVertexSize() * triangles.size() * 3));
        int size = triangles.size();
        for (int i = 0; i < size; ++i) {
            TessellatorManager.writePrimitiveToBuffer(triangles.get(i), buffer, format);
        }
        buffer.rewind();
        return new VertexBuffer(format, 4).upload(buffer);
    }

    private static VertexBuffer createQuadVBO(List<ModelQuad> quads, VertexFormat format) {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(format.getVertexSize() * quads.size() * 4));
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            format.writeQuad(quads.get(i), buffer);
        }
        buffer.rewind();
        return new VertexBuffer(format, 7).upload(buffer);
    }

    private static void writePrimitiveToBuffer(ModelPrimitiveView prim, ByteBuffer buffer, VertexFormat format) {
        if (format.getVertexSize() != 32) {
            throw new IllegalArgumentException("writePrimitiveToBuffer requires vertex size of 32 bytes, but format has " + format.getVertexSize() + ". Use a compatible format or implement a custom primitive writer.");
        }
        for (int i = 0; i < prim.getVertexCount(); ++i) {
            buffer.putFloat(prim.getX(i));
            buffer.putFloat(prim.getY(i));
            buffer.putFloat(prim.getZ(i));
            buffer.putInt(prim.getColor(i));
            buffer.putFloat(prim.getTexU(i));
            buffer.putFloat(prim.getTexV(i));
            buffer.putInt(prim.getLight(i));
            buffer.putInt(prim.getForgeNormal(i));
        }
    }

    public static VertexBuffer stopCapturingToVBO(VertexBuffer vbo, VertexFormat format) {
        if (vbo == null) {
            vbo = new VertexBuffer(format, 7);
        }
        return vbo.upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static VertexBuffer stopCapturingToVAO(VertexFormat format) {
        return VAOManager.createVAO(format, 7).upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static VertexBuffer stopCapturingToVAO(VertexBuffer vao, VertexFormat format) {
        if (vao == null) {
            vao = VAOManager.createVAO(format, 7);
        }
        return vao.upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static boolean shouldInterceptDraw(Tessellator tess) {
        return ((ITessellatorInstance)tess).gtnhlib$isCompiling();
    }

    public static int interceptDraw(Tessellator tess) {
        if (isInCompilingCallback) {
            throw new IllegalStateException("Tessellator.draw() called from within a compiling callback - this is not allowed!");
        }
        CaptureState current = TessellatorManager.requireMode(CaptureMode.COMPILING, "interceptDraw called but not in COMPILING mode!");
        if (current.callback == null) {
            throw new IllegalStateException("interceptDraw called but callback is null!");
        }
        CapturingTessellator helper = capturingTessellator.get();
        if (tess.field_78409_u == 7) {
            QuadExtractor.buildQuadsFromBuffer(tess.field_78405_h, tess.field_78406_i, tess.field_78409_u, true, tess.field_78414_p, tess.field_78399_n, tess.field_78413_q, 0, 0, 0, -1, helper.quadPool, helper.collectedQuads, helper.flags);
        } else {
            PrimitiveExtractor.buildPrimitivesFromBuffer(tess.field_78405_h, tess.field_78406_i, tess.field_78409_u, true, tess.field_78414_p, tess.field_78399_n, tess.field_78413_q, 0, 0, 0, -1, helper.quadPool, helper.triPool, helper.linePool, helper.collectedPrimitives, helper.flags);
        }
        isInCompilingCallback = true;
        try {
            current.callback.onDraw(helper.collectedQuads, helper.collectedPrimitives, helper.flags);
        }
        finally {
            isInCompilingCallback = false;
        }
        helper.clearQuads();
        helper.clearPrimitives();
        int result = tess.field_147569_p * 4;
        ((ITessellatorInstance)tess).discard();
        return result;
    }

    static int processDrawForCapturingTessellator(CapturingTessellator tess) {
        boolean isCompiling;
        CaptureState current = TessellatorManager.peekState();
        boolean bl = isCompiling = current != null && current.mode == CaptureMode.COMPILING;
        if (isCompiling) {
            if (tess.field_78409_u == 7) {
                QuadExtractor.buildQuadsFromBuffer(tess.field_78405_h, tess.field_78406_i, tess.field_78409_u, tess.field_78400_o, tess.field_78414_p, tess.field_78399_n, tess.field_78413_q, -tess.offset.x, -tess.offset.y, -tess.offset.z, tess.shaderBlockId, tess.quadPool, tess.collectedQuads, tess.flags);
            } else {
                PrimitiveExtractor.buildPrimitivesFromBuffer(tess.field_78405_h, tess.field_78406_i, tess.field_78409_u, tess.field_78400_o, tess.field_78414_p, tess.field_78399_n, tess.field_78413_q, -tess.offset.x, -tess.offset.y, -tess.offset.z, tess.shaderBlockId, tess.quadPool, tess.triPool, tess.linePool, tess.collectedPrimitives, tess.flags);
            }
            current.callback.onDraw(tess.collectedQuads, tess.collectedPrimitives, tess.flags);
            tess.clearQuads();
            tess.clearPrimitives();
        } else if (tess.field_78409_u == 7 || tess.field_78409_u == 4) {
            QuadExtractor.buildQuadsFromBuffer(tess.field_78405_h, tess.field_78406_i, tess.field_78409_u, tess.field_78400_o, tess.field_78414_p, tess.field_78399_n, tess.field_78413_q, -tess.offset.x, -tess.offset.y, -tess.offset.z, tess.shaderBlockId, tess.quadPool, tess.collectedQuads, tess.flags);
        } else {
            PrimitiveExtractor.buildPrimitivesFromBuffer(tess.field_78405_h, tess.field_78406_i, tess.field_78409_u, tess.field_78400_o, tess.field_78414_p, tess.field_78399_n, tess.field_78413_q, -tess.offset.x, -tess.offset.y, -tess.offset.z, tess.shaderBlockId, tess.quadPool, tess.triPool, tess.linePool, tess.collectedPrimitives, tess.flags);
        }
        int result = tess.field_147569_p * 4;
        tess.discard();
        return result;
    }

    public static void cleanup() {
        CaptureState current;
        CapturingTessellator tessellator = capturingTessellator.get();
        ArrayList<CaptureState> stack = captureStack.get();
        if (TessellatorManager.isOnMainThread() && (current = TessellatorManager.peekState()) != null && current.mode == CaptureMode.COMPILING) {
            LOGGER.warn("[TessellatorManager] cleanup() called while compiling is active - this may indicate cleanup() called during display list compilation!", (Throwable)new Exception("Stack trace"));
            TessellatorManager.setVanillaTessellatorCompiling(false);
        }
        stack.clear();
        tessellator.discard();
        tessellator.clearQuads();
        tessellator.clearPrimitives();
        isInCompilingCallback = false;
    }

    public static void setCompiling(DrawCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        if (!TessellatorManager.isOnMainThread()) {
            throw new IllegalStateException("Display list compilation can only happen on main thread!");
        }
        ArrayList<CaptureState> stack = captureStack.get();
        CapturingTessellator tess = capturingTessellator.get();
        if (!tess.getQuads().isEmpty()) {
            throw new IllegalStateException("Tried to start compiling with existing collected Quads!");
        }
        stack.add(new CaptureState(CaptureMode.COMPILING, callback));
        TessellatorManager.setVanillaTessellatorCompiling(true);
        tess.storeTranslation();
    }

    public static void stopCompiling() {
        if (!TessellatorManager.isOnMainThread()) {
            throw new IllegalStateException("stopCompiling() can only be called from main thread!");
        }
        TessellatorManager.requireMode(CaptureMode.COMPILING, "Not currently compiling!");
        ArrayList<CaptureState> stack = captureStack.get();
        CapturingTessellator tess = capturingTessellator.get();
        if (tess.field_78415_z) {
            tess.func_78381_a();
        }
        stack.remove(stack.size() - 1);
        if (!TessellatorManager.hasCompilingInStack(stack)) {
            TessellatorManager.setVanillaTessellatorCompiling(false);
        }
        tess.clearQuads();
        tess.discard();
        tess.restoreTranslation();
    }

    private static class CaptureState {
        final CaptureMode mode;
        final DrawCallback callback;
        List<ModelQuadViewMutable> savedQuads;

        CaptureState(CaptureMode mode, DrawCallback callback) {
            this.mode = mode;
            this.callback = callback;
        }
    }

    private static enum CaptureMode {
        CAPTURING,
        COMPILING;

    }

    public static final class CapturedGeometry {
        private final List<VertexBuffer> vbos;

        public CapturedGeometry(List<VertexBuffer> vbos) {
            this.vbos = vbos;
        }

        public boolean isEmpty() {
            return this.vbos.isEmpty();
        }

        public void delete() {
            int size = this.vbos.size();
            for (int i = 0; i < size; ++i) {
                this.vbos.get(i).delete();
            }
        }

        public void renderAll() {
            int size = this.vbos.size();
            for (int i = 0; i < size; ++i) {
                this.vbos.get(i).render();
            }
        }

        public String toString() {
            return "CapturedGeometry[" + "vbos=" + this.vbos + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.vbos != null ? this.vbos.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(((CapturedGeometry)arg0).vbos, this.vbos);
            {
            }
        }

        public List<VertexBuffer> vbos() {
            return this.vbos;
        }
    }
}

