/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.postprocessing;

import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.CustomFramebuffer;
import com.gtnewhorizon.gtnhlib.compat.Mods;
import net.coderbot.iris.rendertarget.IRenderTargetExt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class SharedDepthFramebuffer
extends CustomFramebuffer {
    private final Framebuffer linkedBuffer;

    public SharedDepthFramebuffer(int settings, Framebuffer linkedBuffer) {
        super(settings);
        if (linkedBuffer == null) {
            throw new IllegalArgumentException("linkedBuffer cannot be null!");
        }
        this.linkedBuffer = linkedBuffer;
    }

    public SharedDepthFramebuffer(int width, int height, int settings, Framebuffer linkedBuffer) {
        super(width, height, settings);
        if (linkedBuffer == null) {
            throw new IllegalArgumentException("linkedBuffer cannot be null!");
        }
        this.linkedBuffer = linkedBuffer;
    }

    public SharedDepthFramebuffer(int settings) {
        this(settings, Minecraft.func_71410_x().func_147110_a());
    }

    public SharedDepthFramebuffer(int width, int height, int settings) {
        this(width, height, settings, Minecraft.func_71410_x().func_147110_a());
    }

    @Override
    protected void createDepthAttachment(int width, int height) {
        this.depthAttachment = -1;
    }

    @Override
    protected final int createBufferBits() {
        return 16384;
    }

    private void linkDepthAttachment() {
        OpenGlHelper.func_153188_a((int)36160, (int)36096, (int)3553, (int)this.depthAttachment, (int)0);
        if (this.isEnabled(5) && SharedDepthFramebuffer.isMinecraftStencilEnabled()) {
            OpenGlHelper.func_153188_a((int)36160, (int)36128, (int)3553, (int)this.depthAttachment, (int)0);
        }
    }

    @Override
    protected void deleteFramebuffer() {
        this.unbindFramebufferTexture();
        this.unbindFramebuffer();
        this.depthAttachment = -1;
        if (this.framebufferTexture > -1) {
            GL11.glDeleteTextures((int)this.framebufferTexture);
            this.framebufferTexture = -1;
        }
        OpenGlHelper.func_153174_h((int)this.framebufferObject);
        this.framebufferObject = -1;
    }

    @Override
    public void bindFramebuffer() {
        super.bindFramebuffer();
        if (this.linkedBuffer != null) {
            int attachment;
            int n = attachment = Mods.ANGELICA && this.linkedBuffer instanceof IRenderTargetExt ? ((IRenderTargetExt)this.linkedBuffer).iris$getDepthTextureId() : this.linkedBuffer.field_147624_h;
            if (attachment != this.depthAttachment) {
                this.depthAttachment = attachment;
                this.linkDepthAttachment();
            }
        }
    }

    public static boolean isMinecraftStencilEnabled() {
        return MinecraftForgeClient.getStencilBits() != 0;
    }
}

