/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.shader;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL20;

public class ShaderProgram
implements AutoCloseable {
    protected int program;

    public ShaderProgram(String domain, String vertShaderFilename, String fragShaderFilename) {
        int program;
        try {
            program = ShaderProgram.createProgram(domain, vertShaderFilename, fragShaderFilename);
        }
        catch (Exception e) {
            GTNHLib.LOG.error("Could not initialize shader program!", (Throwable)e);
            program = 0;
        }
        this.program = program;
    }

    protected void reload(Path vertexFile, Path fragmentFile) {
        int program;
        try {
            program = ShaderProgram.createProgramFromPath(vertexFile, fragmentFile);
        }
        catch (Exception e) {
            GTNHLib.LOG.error("Could not initialize shader program!", (Throwable)e);
            program = 0;
        }
        this.program = program;
    }

    private static String getProgramLogInfo(int obj) {
        return GL20.glGetProgramInfoLog((int)obj, (int)GL20.glGetProgrami((int)obj, (int)35716));
    }

    private static String getShaderLogInfo(int obj) {
        return GL20.glGetShaderInfoLog((int)obj, (int)GL20.glGetShaderi((int)obj, (int)35716));
    }

    private static int createProgram(String domain, String vertShaderFilename, String fragShaderFilename) {
        if (!OpenGlHelper.field_148824_g) {
            return 0;
        }
        int program = GL20.glCreateProgram();
        int vertShader = ShaderProgram.loadAndCompileShader(program, domain, vertShaderFilename, 35633);
        int fragShader = ShaderProgram.loadAndCompileShader(program, domain, fragShaderFilename, 35632);
        return ShaderProgram.linkValidateShader(program, vertShader, fragShader);
    }

    private static int loadAndCompileShader(int program, String domain, String filename, int shaderType) {
        if (filename == null) {
            return 0;
        }
        int shader = GL20.glCreateShader((int)shaderType);
        if (shader == 0) {
            GTNHLib.LOG.error("Could not create shader of type {} from {}: {}", new Object[]{shaderType, filename, ShaderProgram.getProgramLogInfo(program)});
            return 0;
        }
        String code = ShaderProgram.loadFile(new ResourceLocation(domain, filename));
        if (code == null) {
            GL20.glDeleteShader((int)shader);
            return 0;
        }
        GL20.glShaderSource((int)shader, (CharSequence)code);
        GL20.glCompileShader((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
            GTNHLib.LOG.error("Could not compile shader {}: {}", new Object[]{filename, ShaderProgram.getShaderLogInfo(shader)});
            GL20.glDeleteShader((int)shader);
            return 0;
        }
        return shader;
    }

    private static int linkValidateShader(int program, int vertShader, int fragShader) {
        if (vertShader != 0) {
            GL20.glAttachShader((int)program, (int)vertShader);
        }
        if (fragShader != 0) {
            GL20.glAttachShader((int)program, (int)fragShader);
        }
        GL20.glLinkProgram((int)program);
        if (vertShader != 0) {
            GL20.glDeleteShader((int)vertShader);
        }
        if (fragShader != 0) {
            GL20.glDeleteShader((int)fragShader);
        }
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            GTNHLib.LOG.error("Could not link shader: {}", new Object[]{ShaderProgram.getProgramLogInfo(program)});
            GL20.glDeleteProgram((int)program);
            return 0;
        }
        GL20.glValidateProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35715) == 0) {
            GTNHLib.LOG.error("Could not validate shader: {}", new Object[]{ShaderProgram.getProgramLogInfo(program)});
            GL20.glDeleteProgram((int)program);
            return 0;
        }
        return program;
    }

    private static int createProgramFromPath(Path vertexPath, Path fragmentPath) {
        if (!OpenGlHelper.field_148824_g) {
            return 0;
        }
        int program = GL20.glCreateProgram();
        int vertShader = ShaderProgram.loadAndCompileShader(program, vertexPath, 35633);
        int fragShader = ShaderProgram.loadAndCompileShader(program, fragmentPath, 35632);
        return ShaderProgram.linkValidateShader(program, vertShader, fragShader);
    }

    private static int loadAndCompileShader(int program, Path path, int shaderType) {
        int shader = GL20.glCreateShader((int)shaderType);
        String code = ShaderProgram.loadFileFromPath(path);
        if (code == null) {
            GL20.glDeleteShader((int)shader);
            return 0;
        }
        GL20.glShaderSource((int)shader, (CharSequence)code);
        GL20.glCompileShader((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
            GTNHLib.LOG.error("Could not compile shader {}: {}", new Object[]{path.toString(), ShaderProgram.getShaderLogInfo(shader)});
            GL20.glDeleteShader((int)shader);
            return 0;
        }
        return shader;
    }

    private static String loadFile(ResourceLocation resourceLocation) {
        try {
            String line;
            StringBuilder code = new StringBuilder();
            InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                code.append(line);
                code.append('\n');
            }
            reader.close();
            return code.toString();
        }
        catch (Exception e) {
            GTNHLib.LOG.error("Could not load shader file!", (Throwable)e);
            return null;
        }
    }

    private static String loadFileFromPath(Path path) {
        String string;
        block9: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                String line;
                StringBuilder code = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    code.append(line).append('\n');
                }
                string = code.toString();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    GTNHLib.LOG.error("Could not load shader file: " + path, (Throwable)e);
                    return null;
                }
            }
            reader.close();
        }
        return string;
    }

    public int getProgram() {
        return this.program;
    }

    public void use() {
        GL20.glUseProgram((int)this.program);
    }

    public static void unbind() {
        GL20.glUseProgram((int)0);
    }

    public static void clear() {
        ShaderProgram.unbind();
    }

    public int getUniformLocation(String name) {
        int index = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No uniform exists with name: " + name);
        }
        return index;
    }

    public int getAttribLocation(String name) {
        int index = GL20.glGetAttribLocation((int)this.program, (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No attribute exists with name: " + name);
        }
        return index;
    }

    public void bindTextureSlot(String sampler2DName, int index) {
        GL20.glUniform1i((int)this.getUniformLocation(sampler2DName), (int)index);
    }

    @Override
    public void close() {
        GL20.glDeleteProgram((int)this.program);
    }

    public final void glUniform2f(int location, Vector2f vec2) {
        GL20.glUniform2f((int)location, (float)vec2.x, (float)vec2.y);
    }

    public final void glUniform2f(int location, Vector2f vec2, Vector2f last) {
        if (last.x != vec2.x || last.y != vec2.y) {
            this.glUniform2f(location, vec2);
            last.set(vec2);
        }
    }

    public final void glUniform3f(int location, Vector3f vec3) {
        GL20.glUniform3f((int)location, (float)vec3.x, (float)vec3.y, (float)vec3.z);
    }

    public final void glUniform3f(int location, Vector3f vec3, Vector3f last) {
        if (last.x != vec3.x || last.y != vec3.y || last.z != vec3.z) {
            this.glUniform3f(location, vec3);
            last.set(vec3);
        }
    }
}

