/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.textures;

import com.gtnewhorizon.gtnhlib.client.renderer.textures.SpriteAnimationMetadata;
import com.gtnewhorizon.gtnhlib.client.renderer.textures.TextureLoader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public final class TextureAtlas {
    private final int texture;
    private final SpriteAnimationMetadata[] animationMetadata;
    private final float heightUnit;
    private FloatBuffer uvBuffer;
    private int lastTextureUpdate;

    public static TextureAtlas createTextureAtlas(String domain, String location, int amount) {
        ResourceLocation[] resources = new ResourceLocation[amount];
        for (int i = 0; i < amount; ++i) {
            resources[i] = new ResourceLocation(domain, location + i + ".png");
        }
        return new TextureAtlas(resources);
    }

    public TextureAtlas(ResourceLocation ... resources) {
        int amount = resources.length;
        this.animationMetadata = new SpriteAnimationMetadata[amount];
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        BufferedImage[] images = new BufferedImage[amount];
        int maxHeight = 0;
        for (int i = 0; i < amount; ++i) {
            ResourceLocation resourceLocation = resources[i];
            try {
                BufferedImage image;
                IResource resource = resourceManager.func_110536_a(resourceLocation);
                images[i] = image = TextureLoader.getBufferedImage(resource);
                this.animationMetadata[i] = new SpriteAnimationMetadata(resource, image);
                if (image.getHeight() <= maxHeight) continue;
                maxHeight = image.getHeight();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int width = images[0].getWidth();
        this.uvBuffer = BufferUtils.createFloatBuffer((int)(amount * 2));
        this.heightUnit = 1.0f / ((float)maxHeight / (float)width);
        int atlasWidth = amount * width;
        int atlasHeight = maxHeight;
        this.texture = TextureLoader.createBindTextureAtlas(6408, 32993, atlasWidth, atlasHeight, images);
    }

    public int getTexture() {
        return this.texture;
    }

    public void bindTexture() {
        GL11.glBindTexture((int)3553, (int)this.texture);
    }

    public boolean needsAnimationUpdate() {
        return Minecraft.func_71410_x().field_71439_g.field_70173_aa != this.lastTextureUpdate;
    }

    public int getRowCount() {
        return this.animationMetadata.length;
    }

    public FloatBuffer getBuffer() {
        return this.uvBuffer;
    }

    public FloatBuffer updateVBuffer() {
        this.lastTextureUpdate = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
        FloatBuffer uvs = this.uvBuffer;
        uvs.clear();
        for (SpriteAnimationMetadata metadata : this.animationMetadata) {
            metadata.updateAnimation();
            float v = (float)metadata.index * this.heightUnit;
            uvs.put(v);
            uvs.put(v + this.heightUnit);
        }
        uvs.flip();
        return uvs;
    }

    public FloatBuffer updateUVBuffer() {
        if (this.uvBuffer.capacity() < this.animationMetadata.length * 4) {
            this.uvBuffer = BufferUtils.createFloatBuffer((int)(this.animationMetadata.length * 4));
        }
        this.lastTextureUpdate = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
        FloatBuffer uvs = this.uvBuffer;
        uvs.clear();
        float widthUnit = 1.0f / (float)this.getRowCount();
        float u = 0.0f;
        for (SpriteAnimationMetadata metadata : this.animationMetadata) {
            metadata.updateAnimation();
            float v = (float)metadata.index * this.heightUnit;
            uvs.put(u);
            uvs.put(v);
            uvs.put(u += widthUnit);
            uvs.put(v + this.heightUnit);
        }
        uvs.flip();
        return uvs;
    }

    public void uploadVBuffer(int location) {
        if (this.needsAnimationUpdate()) {
            GL20.glUniform2((int)location, (FloatBuffer)this.updateVBuffer());
        }
    }

    public void uploadUVBuffer(int location) {
        if (this.needsAnimationUpdate()) {
            GL20.glUniform2((int)location, (FloatBuffer)this.updateUVBuffer());
        }
    }
}

