/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vao;

import com.gtnewhorizon.gtnhlib.client.renderer.vao.VAOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;

public class VertexArrayBuffer
extends VertexBuffer {
    protected int vaoID = -1;

    protected VertexArrayBuffer(VertexFormat format, int drawMode) {
        super(format, drawMode);
    }

    @Override
    public void close() {
        super.close();
        if (this.vaoID >= 0) {
            VAOManager.VAO.glDeleteVertexArrays(this.vaoID);
            this.vaoID = -1;
        }
    }

    @Override
    public final void bind() {
        if (this.vaoID == -1) {
            this.vaoID = VAOManager.VAO.glGenVertexArrays();
            VAOManager.VAO.glBindVertexArray(this.vaoID);
            this.bindVBO();
            this.format.setupBufferState(0L);
            this.unbindVBO();
        } else {
            VAOManager.VAO.glBindVertexArray(this.vaoID);
        }
    }

    @Override
    public final void unbind() {
        VAOManager.VAO.glBindVertexArray(0);
    }

    @Override
    public final void setupState() {
        this.bind();
    }

    @Override
    public final void cleanupState() {
        this.unbind();
    }

    public int getVaoID() {
        return this.vaoID;
    }
}

