/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.color;

import com.gtnewhorizon.gtnhlib.color.ImmutableColor;
import java.awt.Color;

public class HSVColor
implements ImmutableColor {
    public float hue;
    public float saturation;
    public float brightness;

    public HSVColor() {
    }

    public HSVColor(float hue, float saturation, float brightness) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
    }

    @Override
    public int toIntRGB() {
        return this.toIntARGB() & 0xFFFFFF;
    }

    @Override
    public int toIntARGB() {
        return Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
    }

    @Override
    public int toIntRGBA() {
        return this.toIntRGB() << 8 | 0xFF;
    }

    @Override
    public HSVColor toHSV() {
        return new HSVColor(this.hue, this.saturation, this.brightness);
    }

    @Override
    public int getRed() {
        return this.toIntARGB() >> 16 & 0xFF;
    }

    @Override
    public int getGreen() {
        return this.toIntARGB() >> 8 & 0xFF;
    }

    @Override
    public int getBlue() {
        return this.toIntARGB() & 0xFF;
    }

    @Override
    public int getAlpha() {
        return 255;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof HSVColor)) {
            return false;
        }
        HSVColor hsvColor = (HSVColor)o;
        return Float.compare(this.hue, hsvColor.hue) == 0 && Float.compare(this.saturation, hsvColor.saturation) == 0 && Float.compare(this.brightness, hsvColor.brightness) == 0;
    }

    public int hashCode() {
        int result = Float.hashCode(this.hue);
        result = 31 * result + Float.hashCode(this.saturation);
        result = 31 * result + Float.hashCode(this.brightness);
        return result;
    }

    public String toString() {
        return "HSVColor{hue=" + this.hue + ", saturation=" + this.saturation + ", brightness=" + this.brightness + '}';
    }
}

