/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.command;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.registry.BlockPropertyRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class BlockStateCommand
extends CommandBase {
    public String getCommandName() {
        return "blockstate";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "/blockstate <get|set> [property name] [property value]";
    }

    public List<String> getCommandAliases() {
        return new ArrayList<String>();
    }

    public void processCommand(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        String action = BlockProperty.getIndexSafe(args, 0);
        String name = BlockProperty.getIndexSafe(args, 1);
        String value = BlockProperty.getIndexSafe(args, 2);
        if (action == null || "set".equals(action) && name != null && value == null) {
            BlockStateCommand.sendErrorToPlayer(sender, this.getCommandUsage(sender));
            return;
        }
        MovingObjectPosition hit = BlockStateCommand.getHitResult(player);
        if (hit == null || hit.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            BlockStateCommand.sendErrorToPlayer(sender, "You must be looking at a block to use this command.");
            return;
        }
        Object2ObjectOpenHashMap properties = new Object2ObjectOpenHashMap();
        BlockPropertyRegistry.getProperties((IBlockAccess)player.worldObj, hit.blockX, hit.blockY, hit.blockZ, properties);
        if ("get".equals(action)) {
            if (name != null) {
                BlockProperty prop = (BlockProperty)properties.get(name);
                if (prop != null) {
                    Object v = prop.getValue((IBlockAccess)player.worldObj, hit.blockX, hit.blockY, hit.blockZ);
                    BlockStateCommand.sendChatToPlayer(sender, prop.getName() + ": " + prop.stringify(v));
                    return;
                }
                BlockStateCommand.sendErrorToPlayer(sender, "Property not found.");
            } else {
                BlockStateCommand.sendChatToPlayer((ICommandSender)player, "Properties:");
                if (properties.isEmpty()) {
                    BlockStateCommand.sendChatToPlayer((ICommandSender)player, "None");
                    return;
                }
                for (Map.Entry e : properties.entrySet()) {
                    BlockProperty prop = (BlockProperty)e.getValue();
                    Object v = prop.getValue((IBlockAccess)player.worldObj, hit.blockX, hit.blockY, hit.blockZ);
                    BlockStateCommand.sendChatToPlayer((ICommandSender)player, prop.getName() + ": " + prop.stringify(v));
                }
            }
        } else {
            BlockProperty prop = (BlockProperty)properties.get(name);
            if (prop != null) {
                try {
                    Object v = prop.parse(value);
                    prop.setValue(player.worldObj, hit.blockX, hit.blockY, hit.blockZ, v);
                }
                catch (Throwable t) {
                    GTNHLib.LOG.error("Error setting property {}", new Object[]{name, t});
                    BlockStateCommand.sendErrorToPlayer((ICommandSender)player, "Error setting property: " + t.getMessage());
                }
                return;
            }
            BlockStateCommand.sendErrorToPlayer(sender, "Property not found.");
        }
    }

    private static MovingObjectPosition getHitResult(EntityPlayer player) {
        double d;
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            d = mp.theItemInWorldManager.getBlockReachDistance();
        } else {
            d = Minecraft.getMinecraft().playerController.getBlockReachDistance();
        }
        double reachDistance = d;
        Vec3 posVec = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 lookVec = player.getLook(1.0f);
        Vec3 modifiedPosVec = posVec.addVector(lookVec.xCoord * reachDistance, lookVec.yCoord * reachDistance, lookVec.zCoord * reachDistance);
        MovingObjectPosition hit = player.worldObj.rayTraceBlocks(posVec, modifiedPosVec, true);
        return hit != null && hit.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK ? null : hit;
    }

    private static void sendErrorToPlayer(ICommandSender sender, String aChatMessage) {
        sender.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + aChatMessage));
    }

    private static void sendChatToPlayer(ICommandSender sender, String aChatMessage) {
        sender.addChatMessage((IChatComponent)new ChatComponentText(aChatMessage));
    }
}

