/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.core;

import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public interface MetaBlockProperty<T>
extends BlockProperty<T> {
    public int getMeta(T var1, int var2);

    public T getValue(int var1);

    @Override
    default public boolean appliesTo(IBlockAccess world, int x, int y, int z, Block block, int meta, @Nullable TileEntity tile) {
        return this.appliesTo(meta);
    }

    @Override
    default public boolean appliesTo(ItemStack stack, Item item, int meta) {
        return this.appliesTo(item.getMetadata(meta));
    }

    default public boolean appliesTo(int meta) {
        return true;
    }

    default public boolean needsExisting() {
        return true;
    }

    @Override
    default public T getValue(IBlockAccess world, int x, int y, int z) {
        if (!this.hasTrait(BlockPropertyTrait.SupportsWorld)) {
            throw new UnsupportedOperationException();
        }
        return this.getValue(world.getBlockMetadata(x, y, z));
    }

    @Override
    default public void setValue(World world, int x, int y, int z, T value) {
        if (!this.hasTrait(BlockPropertyTrait.SupportsWorld)) {
            throw new UnsupportedOperationException();
        }
        boolean needsExisting = this.needsExisting();
        int existing = needsExisting ? world.getBlockMetadata(x, y, z) : 0;
        int meta = this.getMeta(value, existing);
        if (!needsExisting || existing != meta) {
            world.setBlockMetadataWithNotify(x, y, z, meta, 2);
        }
    }

    @Override
    default public T getValue(ItemStack stack) {
        if (!this.hasTrait(BlockPropertyTrait.SupportsStacks)) {
            throw new UnsupportedOperationException();
        }
        int meta = stack.getItem().getMetadata(stack.getItemDamage());
        return this.getValue(meta);
    }

    @Override
    default public void setValue(ItemStack stack, T t) {
        if (!this.hasTrait(BlockPropertyTrait.SupportsStacks)) {
            throw new UnsupportedOperationException();
        }
        int meta = this.needsExisting() ? stack.getItem().getMetadata(stack.getItemDamage()) : 0;
        meta = this.getMeta(t, meta);
        stack.setItemDamage(((ItemBlock)stack.getItem()).field_150939_a.damageDropped(meta));
    }
}

