/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.color;

import com.gtnewhorizon.gtnhlib.client.model.color.IBlockColor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class BlockColor {
    private static final Map<Block, IBlockColor> HANDLERS = new HashMap<Block, IBlockColor>();

    public static void registerBlockColors(IBlockColor handler, Block ... blocks) {
        for (Block b : blocks) {
            HANDLERS.put(b, handler);
        }
    }

    public IBlockColor getBlockColor(Block block) {
        return HANDLERS.get(block);
    }

    public static int getColor(Block block, IBlockAccess world, int x, int y, int z, int meta, int tintIndex) {
        return BlockColor.getColor(block, world, null, x, y, z, meta, tintIndex);
    }

    public static int getColor(Block block, ItemStack stack, int tintIndex) {
        return BlockColor.getColor(block, null, stack, 0, 0, 0, stack.getItemDamage(), tintIndex);
    }

    public static int getColor(Block block, @Nullable IBlockAccess world, @Nullable ItemStack stack, int x, int y, int z, int meta, int tintIndex) {
        int color = -1;
        IBlockColor handler = HANDLERS.get(block);
        if (handler == null && block instanceof IBlockColor) {
            handler = (IBlockColor)block;
        }
        if (handler != null && (color = BlockColor.applyHandler(handler, world, stack, x, y, z, tintIndex)) != -1) {
            return color;
        }
        if (stack != null && stack.getItem() != null) {
            return stack.getItem().getColorFromItemStack(stack, tintIndex);
        }
        if (world != null) {
            return block.colorMultiplier(world, x, y, z);
        }
        return block.getRenderColor(meta);
    }

    private static int applyHandler(@Nullable IBlockColor handler, @Nullable IBlockAccess world, @Nullable ItemStack stack, int x, int y, int z, int tintIndex) {
        if (handler == null) {
            return -1;
        }
        if (stack != null) {
            return handler.colorMultiplier(stack, tintIndex);
        }
        if (world != null) {
            return handler.colorMultiplier(world, x, y, z, tintIndex);
        }
        return -1;
    }
}

