/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.tooltip;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.client.tooltip.LoreHolder;
import com.gtnewhorizon.gtnhlib.reflect.Fields;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class LoreHolderDiscoverer {
    static final Map<Fields.ClassFields.Field<String>, String> LORE_HOLDERS = new HashMap<Fields.ClassFields.Field<String>, String>();
    static final List<LoreField> LORE_FIELDS = new ArrayList<LoreField>();

    public static void harvestData(ASMDataTable table) {
        for (ASMDataTable.ASMData asmData : table.getAll(LoreHolder.class.getName())) {
            String className = asmData.getClassName();
            String fieldName = asmData.getObjectName();
            String key = (String)asmData.getAnnotationInfo().get("value");
            if (!StringUtils.isNotBlank((CharSequence)key)) continue;
            LORE_FIELDS.add(new LoreField(className, fieldName, key));
        }
    }

    static void register() {
        for (LoreField loreField : LORE_FIELDS) {
            Fields.ClassFields.Field<String> field;
            Class<?> clazz;
            String className = loreField.getClassName();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                GTNHLib.LOG.error("Class {} could not be found!", new Object[]{className, e});
                continue;
            }
            String fieldName = loreField.getFieldName();
            try {
                field = Fields.ofClass(clazz).getField(Fields.LookupType.DECLARED, fieldName, String.class);
            }
            catch (ClassCastException e) {
                GTNHLib.LOG.error("Field {} of class {} is not of type java.lang.String!", new Object[]{fieldName, className, e});
                continue;
            }
            if (field == null) {
                GTNHLib.LOG.error("Field {} of class {} could not be found!", new Object[]{fieldName, className});
                continue;
            }
            if (!field.isStatic) {
                GTNHLib.LOG.error("Field {} of class {} is not static!", new Object[]{fieldName, className});
                continue;
            }
            LORE_HOLDERS.put(field, loreField.getKey());
        }
    }

    private static class LoreField {
        private final String className;
        private final String fieldName;
        private final String key;

        @Generated
        public LoreField(String className, String fieldName, String key) {
            this.className = className;
            this.fieldName = fieldName;
            this.key = key;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public String getFieldName() {
            return this.fieldName;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoreField)) {
                return false;
            }
            LoreField other = (LoreField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoreField;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LoreHolderDiscoverer.LoreField(className=" + this.getClassName() + ", fieldName=" + this.getFieldName() + ", key=" + this.getKey() + ")";
        }
    }
}

