/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.color;

import com.gtnewhorizon.gtnhlib.color.HSVColor;
import com.gtnewhorizon.gtnhlib.color.RGBColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public interface ImmutableColor {
    public int getRed();

    public int getGreen();

    public int getBlue();

    public int getAlpha();

    default public int toIntRGB() {
        return (this.getRed() & 0xFF) << 16 | (this.getGreen() & 0xFF) << 8 | this.getBlue() & 0xFF;
    }

    default public int toIntARGB() {
        return (this.getAlpha() & 0xFF) << 24 | (this.getRed() & 0xFF) << 16 | (this.getGreen() & 0xFF) << 8 | this.getBlue() & 0xFF;
    }

    default public int toIntRGBA() {
        return (this.getRed() & 0xFF) << 24 | (this.getGreen() & 0xFF) << 16 | (this.getBlue() & 0xFF) << 8 | this.getAlpha() & 0xFF;
    }

    default public int toIntABGR() {
        return this.getRed() & 0xFF | (this.getGreen() & 0xFF) << 8 | (this.getBlue() & 0xFF) << 16 | (this.getAlpha() & 0xFF) << 24;
    }

    default public RGBColor toRGB() {
        return new RGBColor(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    default public HSVColor toHSV() {
        float[] hsv = Color.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
        return new HSVColor(hsv[0], hsv[1], hsv[2]);
    }

    @SideOnly(value=Side.CLIENT)
    default public void makeActive() {
        GL11.glColor4f((float)((float)this.getRed() / 256.0f), (float)((float)this.getGreen() / 256.0f), (float)((float)this.getBlue() / 256.0f), (float)((float)this.getAlpha() / 256.0f));
    }

    default public short[] toShorts() {
        return new short[]{(short)this.getRed(), (short)this.getGreen(), (short)this.getBlue(), (short)this.getAlpha()};
    }

    public static HSVColor lerp(ImmutableColor a, ImmutableColor b, float k) {
        HSVColor hsv;
        HSVColor hsv2;
        HSVColor hsvA = a instanceof HSVColor ? (hsv2 = (HSVColor)a) : a.toHSV();
        HSVColor hsvB = b instanceof HSVColor ? (hsv = (HSVColor)b) : b.toHSV();
        return new HSVColor(ImmutableColor.lerp(hsvA.hue, hsvB.hue, k), ImmutableColor.lerp(hsvA.saturation, hsvB.saturation, k), ImmutableColor.lerp(hsvA.brightness, hsvB.brightness, k));
    }

    public static float lerp(float a, float b, float k) {
        return a * (1.0f - k) + b * k;
    }
}

