/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.geometry;

import net.minecraftforge.common.util.ForgeDirection;

public enum Axis {
    X,
    Y,
    Z,
    UNKNOWN;


    public static Axis fromDirection(ForgeDirection dir) {
        Axis axis;
        switch (dir) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EAST: 
            case WEST: {
                axis = X;
                break;
            }
            case UP: 
            case DOWN: {
                axis = Y;
                break;
            }
            case NORTH: 
            case SOUTH: {
                axis = Z;
                break;
            }
            case UNKNOWN: {
                axis = UNKNOWN;
            }
        }
        return axis;
    }

    public ForgeDirection positive() {
        ForgeDirection forgeDirection;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case X: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case Y: {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case Z: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case UNKNOWN: {
                forgeDirection = ForgeDirection.UNKNOWN;
            }
        }
        return forgeDirection;
    }

    public ForgeDirection negative() {
        ForgeDirection forgeDirection;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case X: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case Y: {
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case Z: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case UNKNOWN: {
                forgeDirection = ForgeDirection.UNKNOWN;
            }
        }
        return forgeDirection;
    }

    public ForgeDirection flip(ForgeDirection dir) {
        switch (this) {
            case X: {
                if (dir == ForgeDirection.WEST) {
                    return ForgeDirection.EAST;
                }
                if (dir != ForgeDirection.EAST) break;
                return ForgeDirection.WEST;
            }
            case Y: {
                if (dir == ForgeDirection.DOWN) {
                    return ForgeDirection.UP;
                }
                if (dir != ForgeDirection.UP) break;
                return ForgeDirection.DOWN;
            }
            case Z: {
                if (dir == ForgeDirection.NORTH) {
                    return ForgeDirection.SOUTH;
                }
                if (dir != ForgeDirection.SOUTH) break;
                return ForgeDirection.NORTH;
            }
            case UNKNOWN: {
                return ForgeDirection.UNKNOWN;
            }
        }
        return dir;
    }
}

