/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.blockpos.IBlockPos;
import com.gtnewhorizon.gtnhlib.blockpos.IWorldReferent;
import com.gtnewhorizon.gtnhlib.capability.item.ItemSink;
import com.gtnewhorizon.gtnhlib.capability.item.ItemSource;
import com.gtnewhorizon.gtnhlib.item.DroppingItemSink;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InsertionItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import com.gtnewhorizon.gtnhlib.item.ItemStackPredicate;
import com.gtnewhorizon.gtnhlib.util.ItemUtil;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemTransfer {
    protected ItemSource source;
    protected ItemSink sink;
    protected ItemSink itemDropping;
    protected int stacksToTransfer = 1;
    protected int maxItemsPerTransfer = 64;
    protected int maxTotalTransferred = Integer.MAX_VALUE;
    protected int totalItemsTransferred = 0;
    protected int totalStacksTransferred = 0;
    protected int prevItemsTransferred = 0;
    protected int prevStacksTransferred = 0;
    protected int[] sourceSlots;
    protected int[] sinkSlots;
    protected ItemStackPredicate filter;
    protected Consumer<ItemStack> rejectedStacks;

    public void source(ItemSource source) {
        this.source = source;
    }

    public void source(Object source, ForgeDirection side) {
        this.source = ItemUtil.getItemSource(source, side);
    }

    public void sink(ItemSink sink) {
        this.sink = sink;
    }

    public void sink(Object sink, ForgeDirection side) {
        this.sink = ItemUtil.getItemSink(sink, side);
    }

    public <Coord extends IBlockPos & IWorldReferent> void push(Coord pos, ForgeDirection side) {
        TileEntity self = ((IWorldReferent)pos).getWorld().getTileEntity(pos.getX(), pos.getY(), pos.getZ());
        TileEntity adjacent = ((IWorldReferent)pos).getWorld().getTileEntity(pos.getX() + side.offsetX, pos.getY() + side.offsetY, pos.getZ() + side.offsetZ);
        this.push(self, side, adjacent);
    }

    public void push(Object self, ForgeDirection side, Object target) {
        this.source(self, side);
        this.sink(target, side.getOpposite());
    }

    public <Coord extends IBlockPos & IWorldReferent> void pull(Coord pos, ForgeDirection side) {
        TileEntity self = ((IWorldReferent)pos).getWorld().getTileEntity(pos.getX(), pos.getY(), pos.getZ());
        TileEntity adjacent = ((IWorldReferent)pos).getWorld().getTileEntity(pos.getX() + side.offsetX, pos.getY() + side.offsetY, pos.getZ() + side.offsetZ);
        this.pull(self, side, adjacent);
    }

    public void pull(Object self, ForgeDirection side, Object target) {
        this.source(target, side.getOpposite());
        this.sink(self, side);
    }

    public void dropItems(World world, IBlockPos pos) {
        this.itemDropping = new DroppingItemSink(world, pos);
        if (this.rejectedStacks == null) {
            this.rejectedStacks = stack -> this.itemDropping.store(new InsertionItemStack((ItemStack)stack));
        }
    }

    public <Coord extends IBlockPos & IWorldReferent> void dropItems(Coord pos, ForgeDirection output) {
        this.dropItems(((IWorldReferent)pos).getWorld(), pos.offset(output));
    }

    public void setSourceSlots(int ... sourceSlots) {
        this.sourceSlots = sourceSlots;
    }

    public void setSinkSlots(int ... sinkSlots) {
        this.sinkSlots = sinkSlots;
    }

    public int transfer() {
        ItemSink sink;
        ItemSink itemSink = sink = this.sink == null ? this.itemDropping : this.sink;
        if (this.source == null) {
            return 0;
        }
        if (sink == null) {
            return 0;
        }
        if (this.stacksToTransfer == 0) {
            return 0;
        }
        if (this.maxItemsPerTransfer == 0) {
            return 0;
        }
        this.source.resetSource();
        sink.resetSink();
        this.source.setAllowedSourceSlots(this.sourceSlots);
        sink.setAllowedSinkSlots(this.sinkSlots);
        InventoryIterator iter = this.source.sourceIterator();
        if (iter == null) {
            return 0;
        }
        int itemsTransferred = 0;
        int stacksTransferred = 0;
        InsertionItemStack insertion = new InsertionItemStack();
        block0: while (iter.hasNext() && stacksTransferred < this.stacksToTransfer && itemsTransferred < this.maxTotalTransferred) {
            ImmutableItemStack available = (ImmutableItemStack)iter.next();
            if (available == null || available.isEmpty() || this.filter != null && !this.filter.test(available)) continue;
            int availableCount = available.getStackSize();
            while (availableCount > 0) {
                int transferred;
                if (itemsTransferred >= this.maxTotalTransferred || stacksTransferred >= this.stacksToTransfer) break block0;
                int remainingTransferAllowance = this.maxTotalTransferred - itemsTransferred;
                int toTransferThisOP = Math.min(remainingTransferAllowance, this.maxItemsPerTransfer);
                ItemStack extracted = iter.extract(Math.min(availableCount, toTransferThisOP), false);
                if (ItemUtil.isStackEmpty(extracted)) continue block0;
                availableCount -= extracted.stackSize;
                if (this.filter != null && !this.filter.test(extracted)) {
                    if (ItemUtil.isStackEmpty(extracted)) continue;
                    availableCount += extracted.stackSize;
                    int rejected2 = iter.insert(insertion.set(extracted), true);
                    if (rejected2 <= 0 || this.rejectedStacks == null) continue;
                    this.rejectedStacks.accept(insertion.toStack(rejected2));
                    continue;
                }
                int rejected = sink.store(insertion.set(extracted));
                if (rejected > 0) {
                    availableCount += rejected;
                    int rejected2 = iter.insert(insertion.set(extracted, rejected), true);
                    if (rejected2 > 0 && this.rejectedStacks != null) {
                        this.rejectedStacks.accept(insertion.toStack(rejected2));
                    }
                }
                if ((transferred = extracted.stackSize - rejected) <= 0) continue block0;
                itemsTransferred += transferred;
                ++stacksTransferred;
            }
        }
        this.totalItemsTransferred += itemsTransferred;
        this.totalStacksTransferred += stacksTransferred;
        this.prevItemsTransferred = itemsTransferred;
        this.prevStacksTransferred = stacksTransferred;
        return itemsTransferred;
    }

    @Generated
    public ItemSource getSource() {
        return this.source;
    }

    @Generated
    public ItemSink getSink() {
        return this.sink;
    }

    @Generated
    public void setStacksToTransfer(int stacksToTransfer) {
        this.stacksToTransfer = stacksToTransfer;
    }

    @Generated
    public void setMaxItemsPerTransfer(int maxItemsPerTransfer) {
        this.maxItemsPerTransfer = maxItemsPerTransfer;
    }

    @Generated
    public void setMaxTotalTransferred(int maxTotalTransferred) {
        this.maxTotalTransferred = maxTotalTransferred;
    }

    @Generated
    public int getTotalItemsTransferred() {
        return this.totalItemsTransferred;
    }

    @Generated
    public int getTotalStacksTransferred() {
        return this.totalStacksTransferred;
    }

    @Generated
    public int getPrevItemsTransferred() {
        return this.prevItemsTransferred;
    }

    @Generated
    public int getPrevStacksTransferred() {
        return this.prevStacksTransferred;
    }

    @Generated
    public void setFilter(ItemStackPredicate filter) {
        this.filter = filter;
    }

    @Generated
    public void setRejectedStacks(Consumer<ItemStack> rejectedStacks) {
        this.rejectedStacks = rejectedStacks;
    }
}

