/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model;

import com.gtnewhorizon.gtnhlib.client.model.NdQuadBuilder;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TexHelper {
    private static final float NORMALIZER = 0.0625f;
    private static final VertexModifier[] UVLOCKERS = new VertexModifier[6];
    private static final VertexModifier[] ROTATIONS;

    private static void applyModifier(NdQuadBuilder quad, VertexModifier modifier) {
        for (int i = 0; i < 4; ++i) {
            modifier.apply(quad, i);
        }
    }

    public static void bakeSprite(NdQuadBuilder quad, IIcon sprite, int bakeFlags) {
        if (quad.nominalFace() != ForgeDirection.UNKNOWN && (4 & bakeFlags) != 0) {
            TexHelper.applyModifier(quad, UVLOCKERS[quad.nominalFace().ordinal()]);
        } else if ((0x20 & bakeFlags) == 0) {
            TexHelper.applyModifier(quad, (q, i) -> q.uv(i, q.getTexU(i) * 0.0625f, q.getTexV(i) * 0.0625f));
        }
        int rotation = bakeFlags & 3;
        if (rotation != 0) {
            TexHelper.applyModifier(quad, ROTATIONS[rotation]);
        }
        if ((8 & bakeFlags) != 0) {
            TexHelper.applyModifier(quad, (q, i) -> q.uv(i, 1.0f - q.getTexU(i), q.getTexV(i)));
        }
        if ((0x10 & bakeFlags) != 0) {
            TexHelper.applyModifier(quad, (q, i) -> q.uv(i, q.getTexU(i), 1.0f - q.getTexV(i)));
        }
        TexHelper.interpolate(quad, sprite);
    }

    private static void interpolate(NdQuadBuilder q, IIcon sprite) {
        float uMin = sprite.getMinU();
        float uSpan = sprite.getMaxU() - uMin;
        float vMin = sprite.getMinV();
        float vSpan = sprite.getMaxV() - vMin;
        for (int i = 0; i < 4; ++i) {
            q.uv(i, uMin + q.getTexU(i) * uSpan, vMin + q.getTexV(i) * vSpan);
        }
    }

    static {
        TexHelper.UVLOCKERS[ForgeDirection.EAST.ordinal()] = (q, i) -> q.uv(i, 1.0f - q.getZ(i), 1.0f - q.getY(i));
        TexHelper.UVLOCKERS[ForgeDirection.WEST.ordinal()] = (q, i) -> q.uv(i, q.getZ(i), 1.0f - q.getY(i));
        TexHelper.UVLOCKERS[ForgeDirection.NORTH.ordinal()] = (q, i) -> q.uv(i, 1.0f - q.getX(i), 1.0f - q.getY(i));
        TexHelper.UVLOCKERS[ForgeDirection.SOUTH.ordinal()] = (q, i) -> q.uv(i, q.getX(i), 1.0f - q.getY(i));
        TexHelper.UVLOCKERS[ForgeDirection.DOWN.ordinal()] = (q, i) -> q.uv(i, q.getX(i), 1.0f - q.getZ(i));
        TexHelper.UVLOCKERS[ForgeDirection.UP.ordinal()] = (q, i) -> q.uv(i, q.getX(i), q.getZ(i));
        ROTATIONS = new VertexModifier[]{null, (q, i) -> q.uv(i, q.getTexV(i), 1.0f - q.getTexU(i)), (q, i) -> q.uv(i, 1.0f - q.getTexU(i), 1.0f - q.getTexV(i)), (q, i) -> q.uv(i, 1.0f - q.getTexV(i), q.getTexU(i))};
    }

    @FunctionalInterface
    private static interface VertexModifier {
        public void apply(NdQuadBuilder var1, int var2);
    }
}

