/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.shader;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.bytebuf.MemoryStack;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class ShaderProgram
implements AutoCloseable {
    private final int program;

    public ShaderProgram(String domain, String vertShaderFilename, String fragShaderFilename) {
        int program;
        try {
            program = ShaderProgram.createProgram(domain, vertShaderFilename, fragShaderFilename);
        }
        catch (Exception e) {
            GTNHLib.LOG.error("Could not initialize shader program!", (Throwable)e);
            program = 0;
        }
        this.program = program;
    }

    private static String getProgramLogInfo(int obj) {
        return GL20.glGetProgramInfoLog((int)obj, (int)GL20.glGetProgrami((int)obj, (int)35716));
    }

    private static String getShaderLogInfo(int obj) {
        return GL20.glGetShaderInfoLog((int)obj, (int)GL20.glGetShaderi((int)obj, (int)35716));
    }

    private static int createProgram(String domain, String vertShaderFilename, String fragShaderFilename) {
        if (!OpenGlHelper.shadersSupported) {
            return 0;
        }
        int program = GL20.glCreateProgram();
        int vertShader = ShaderProgram.loadAndCompileShader(program, domain, vertShaderFilename, 35633);
        int fragShader = ShaderProgram.loadAndCompileShader(program, domain, fragShaderFilename, 35632);
        if (vertShader != 0) {
            GL20.glAttachShader((int)program, (int)vertShader);
        }
        if (fragShader != 0) {
            GL20.glAttachShader((int)program, (int)fragShader);
        }
        GL20.glLinkProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            GTNHLib.LOG.error("Could not link shader: {}", new Object[]{ShaderProgram.getProgramLogInfo(program)});
            GL20.glDeleteProgram((int)program);
            return 0;
        }
        GL20.glValidateProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35715) == 0) {
            GTNHLib.LOG.error("Could not validate shader: {}", new Object[]{ShaderProgram.getProgramLogInfo(program)});
            GL20.glDeleteProgram((int)program);
            return 0;
        }
        return program;
    }

    private static int loadAndCompileShader(int program, String domain, String filename, int shaderType) {
        if (filename == null) {
            return 0;
        }
        int shader = GL20.glCreateShader((int)shaderType);
        if (shader == 0) {
            GTNHLib.LOG.error("Could not create shader of type {} from {}: {}", new Object[]{shaderType, filename, ShaderProgram.getProgramLogInfo(program)});
            return 0;
        }
        String code = ShaderProgram.loadFile(new ResourceLocation(domain, filename));
        if (code == null) {
            GL20.glDeleteShader((int)shader);
            return 0;
        }
        GL20.glShaderSource((int)shader, (CharSequence)code);
        GL20.glCompileShader((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
            GTNHLib.LOG.error("Could not compile shader {}: {}", new Object[]{filename, ShaderProgram.getShaderLogInfo(shader)});
            GL20.glDeleteShader((int)shader);
            return 0;
        }
        return shader;
    }

    private static String loadFile(ResourceLocation resourceLocation) {
        try {
            String line;
            StringBuilder code = new StringBuilder();
            InputStream inputStream = Minecraft.getMinecraft().getResourceManager().getResource(resourceLocation).getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                code.append(line);
                code.append('\n');
            }
            reader.close();
            return code.toString();
        }
        catch (Exception e) {
            GTNHLib.LOG.error("Could not load shader file!", (Throwable)e);
            return null;
        }
    }

    public int getProgram() {
        return this.program;
    }

    public void use() {
        GL20.glUseProgram((int)this.program);
    }

    public static void clear() {
        GL20.glUseProgram((int)0);
    }

    public int getUniformLocation(String name) {
        int index = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No uniform exists with name: " + name);
        }
        return index;
    }

    public int getAttribLocation(String name) {
        int index = GL20.glGetAttribLocation((int)this.program, (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No attribute exists with name: " + name);
        }
        return index;
    }

    @Override
    public void close() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer shaders = stack.mallocInt(GL20.glGetProgrami((int)this.program, (int)35717));
            GL20.glGetAttachedShaders((int)this.program, null, (IntBuffer)shaders);
            GL20.glDeleteProgram((int)this.program);
            for (int i : shaders.array()) {
                GL20.glDeleteShader((int)i);
            }
        }
    }
}

