/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.config;

import cpw.mods.fml.client.config.ConfigGuiType;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.GuiEditArrayEntries;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class IConfigElementProxy<T>
implements IConfigElement<T> {
    private final IConfigElement<T> proxied;
    private final Runnable onUpdate;

    public IConfigElementProxy(IConfigElement<T> proxied, Runnable onUpdate) {
        this.proxied = proxied;
        this.onUpdate = onUpdate;
    }

    public boolean isProperty() {
        return this.proxied.isProperty();
    }

    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return this.proxied.getConfigEntryClass();
    }

    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return this.proxied.getArrayEntryClass();
    }

    public String getName() {
        return this.proxied.getName();
    }

    public String getQualifiedName() {
        return this.proxied.getQualifiedName();
    }

    public String getLanguageKey() {
        return this.proxied.getLanguageKey();
    }

    public String getComment() {
        return this.proxied.getComment();
    }

    public List<IConfigElement> getChildElements() {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        for (IConfigElement element : this.proxied.getChildElements()) {
            elements.add(new IConfigElementProxy<T>(element, this.onUpdate));
        }
        return elements;
    }

    public ConfigGuiType getType() {
        return this.proxied.getType();
    }

    public boolean isList() {
        return this.proxied.isList();
    }

    public boolean isListLengthFixed() {
        return this.proxied.isListLengthFixed();
    }

    public int getMaxListLength() {
        return this.proxied.getMaxListLength();
    }

    public boolean isDefault() {
        return this.proxied.isDefault();
    }

    public Object getDefault() {
        return this.proxied.getDefault();
    }

    public Object[] getDefaults() {
        return this.proxied.getDefaults();
    }

    public void setToDefault() {
        this.proxied.setToDefault();
    }

    public boolean requiresWorldRestart() {
        return this.proxied.requiresWorldRestart();
    }

    public boolean showInGui() {
        return this.proxied.showInGui();
    }

    public boolean requiresMcRestart() {
        return this.proxied.requiresMcRestart();
    }

    public Object get() {
        return this.proxied.get();
    }

    public Object[] getList() {
        return this.proxied.getList();
    }

    public void set(T value) {
        this.proxied.set(value);
        this.onUpdate.run();
    }

    public void set(T[] aVal) {
        this.proxied.set((Object[])aVal);
        this.onUpdate.run();
    }

    public String[] getValidValues() {
        return this.proxied.getValidValues();
    }

    public T getMinValue() {
        return (T)this.proxied.getMinValue();
    }

    public T getMaxValue() {
        return (T)this.proxied.getMaxValue();
    }

    public Pattern getValidationPattern() {
        return this.proxied.getValidationPattern();
    }
}

