package com.gtnewhorizon.gtnhlib.core;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.gtnewhorizon.gtnhlib.Tags;
import com.gtnewhorizon.gtnhlib.client.tooltip.LoreHolderDiscoverer;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusUtil;

import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLConstructionEvent;

@SuppressWarnings("UnstableApiUsage")
public class GTNHLibCoreModContainer extends DummyModContainer {

    public GTNHLibCoreModContainer() {
        super(new ModMetadata());
        ModMetadata md = getMetadata();
        md.autogenerated = true;
        md.modId = md.name = "GTNHLib Core";
        md.parent = "gtnhlib";
        md.version = Tags.VERSION;
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register(this);
        return true;
    }

    @Subscribe
    public void construct(FMLConstructionEvent event) {
        EventBusUtil.harvestData(event.getASMHarvestedData());
        if (event.getSide().isClient()) {
            LoreHolderDiscoverer.harvestData(event.getASMHarvestedData());
        }
    }
}
