/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.capability.item.ItemSource;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import com.gtnewhorizon.gtnhlib.item.ItemStack2IntFunction;
import com.gtnewhorizon.gtnhlib.item.ItemStackPredicate;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleItemSource
implements ItemSource {
    protected int[] allowedSourceSlots;

    @Override
    public void resetSource() {
        this.allowedSourceSlots = null;
    }

    @Override
    public void setAllowedSourceSlots(int @Nullable [] slots) {
        this.allowedSourceSlots = slots;
    }

    @Override
    @Nullable
    public ItemStack pull(@Nullable ItemStackPredicate filter, @Nullable ItemStack2IntFunction amount) {
        InventoryIterator iter = this.sourceIterator();
        while (iter.hasNext()) {
            ImmutableItemStack stack = (ImmutableItemStack)iter.next();
            if (stack == null || stack.isEmpty() || filter != null && !filter.test(stack)) continue;
            int toExtract = amount == null ? stack.getStackSize() : amount.apply(stack);
            return iter.extract(toExtract, false);
        }
        return null;
    }

    @Override
    @NotNull
    public InventoryIterator sourceIterator() {
        return this.iterator(this.allowedSourceSlots);
    }

    @NotNull
    protected abstract InventoryIterator iterator(int[] var1);
}

