/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.asm;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ClassConstantPoolParser {
    private byte[][] BYTES_TO_SEARCH;

    public ClassConstantPoolParser(String ... strings) {
        this.BYTES_TO_SEARCH = new byte[strings.length][];
        for (int i = 0; i < this.BYTES_TO_SEARCH.length; ++i) {
            this.BYTES_TO_SEARCH[i] = strings[i].getBytes(StandardCharsets.UTF_8);
        }
    }

    public void addString(String string) {
        this.BYTES_TO_SEARCH = (byte[][])Arrays.copyOf(this.BYTES_TO_SEARCH, this.BYTES_TO_SEARCH.length + 1);
        this.BYTES_TO_SEARCH[this.BYTES_TO_SEARCH.length - 1] = string.getBytes(StandardCharsets.UTF_8);
    }

    public boolean find(byte[] basicClass) {
        return this.find(basicClass, false);
    }

    public boolean find(byte[] basicClass, boolean prefixes) {
        if (basicClass == null || basicClass.length == 0) {
            return false;
        }
        int maxSupported = 69;
        short major = ClassConstantPoolParser.readShort(6, basicClass);
        if (major > 69 || major == 69 && ClassConstantPoolParser.readShort(4, basicClass) > 0) {
            return false;
        }
        int numConstants = ClassConstantPoolParser.readUnsignedShort(8, basicClass);
        int index = 10;
        for (int i = 1; i < numConstants; ++i) {
            int size = -1;
            switch (ConstantTypes.toType(basicClass[index])) {
                case UTF8: {
                    int strLen = ClassConstantPoolParser.readUnsignedShort(index + 1, basicClass);
                    size = 3 + strLen;
                    for (byte[] bytes : this.BYTES_TO_SEARCH) {
                        if (prefixes ? strLen < bytes.length : strLen != bytes.length) continue;
                        boolean found = true;
                        for (int j = index + 3; j < index + 3 + bytes.length; ++j) {
                            if (basicClass[j] == bytes[j - (index + 3)]) continue;
                            found = false;
                            break;
                        }
                        if (!found) continue;
                        return true;
                    }
                    break;
                }
                case INT: 
                case FLOAT: 
                case FIELD: 
                case METH_REF: 
                case IMETH_REF: 
                case NAME_TYPE: 
                case DYNAMIC: 
                case INVOKE_DYNAMIC: {
                    size = 5;
                    break;
                }
                case LONG: 
                case DOUBLE: {
                    size = 9;
                    ++i;
                    break;
                }
                case METH_HANDLE: {
                    size = 4;
                    break;
                }
                case CLASS_REF: 
                case STR_REF: 
                case METH_TYPE: 
                case MODULE: 
                case PACKAGE: {
                    size = 3;
                }
            }
            if (size < 0) {
                throw new RuntimeException("Error parsing constant pool!");
            }
            index += size;
        }
        return false;
    }

    private static short readShort(int index, byte[] basicClass) {
        return (short)ClassConstantPoolParser.readUnsignedShort(index, basicClass);
    }

    private static int readUnsignedShort(int index, byte[] basicClass) {
        return (basicClass[index] & 0xFF) << 8 | basicClass[index + 1] & 0xFF;
    }

    static enum ConstantTypes {
        INVALID,
        UTF8,
        INT,
        FLOAT,
        LONG,
        DOUBLE,
        CLASS_REF,
        STR_REF,
        FIELD,
        METH_REF,
        IMETH_REF,
        NAME_TYPE,
        METH_HANDLE,
        METH_TYPE,
        DYNAMIC,
        INVOKE_DYNAMIC,
        MODULE,
        PACKAGE;

        static final ConstantTypes[] MAP;

        static ConstantTypes toType(byte code) {
            ConstantTypes ret = MAP[Byte.toUnsignedInt(code)];
            if (ret == INVALID) {
                throw new RuntimeException("Invalid constant type: " + code);
            }
            return ret;
        }

        static {
            MAP = new ConstantTypes[]{INVALID, UTF8, INVALID, INT, FLOAT, LONG, DOUBLE, CLASS_REF, STR_REF, FIELD, METH_REF, IMETH_REF, NAME_TYPE, INVALID, INVALID, METH_HANDLE, METH_TYPE, DYNAMIC, INVOKE_DYNAMIC, MODULE, PACKAGE};
        }
    }
}

