/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerThreadUtil {
    @NotNull
    private static final Logger logger = LogManager.getLogger();
    @NotNull
    private static final Queue<FutureTask<?>> futureTaskQueue = Queues.newArrayDeque();
    @Nullable
    private static MinecraftServer server;
    @Nullable
    private static Thread serverThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.Internal
    public static void runJobs() {
        Queue<FutureTask<?>> queue = futureTaskQueue;
        synchronized (queue) {
            while (!futureTaskQueue.isEmpty()) {
                FutureTask<?> task = futureTaskQueue.poll();
                try {
                    task.run();
                    task.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error executing task", (Throwable)e);
                }
            }
            return;
        }
    }

    @ApiStatus.Internal
    public static void setup(MinecraftServer server, Thread serverThread) {
        ServerThreadUtil.server = server;
        ServerThreadUtil.serverThread = serverThread;
    }

    @ApiStatus.Internal
    public static void clear() {
        futureTaskQueue.clear();
        server = null;
        serverThread = null;
    }

    public static boolean isCallingFromMinecraftThread() {
        return Thread.currentThread() == serverThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> ListenableFuture<V> callFromMainThread(Callable<V> callable) {
        Validate.notNull(callable);
        if (server == null || server.isServerStopped()) {
            throw new IllegalStateException("Server is not set or not running");
        }
        if (!ServerThreadUtil.isCallingFromMinecraftThread()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable);
            Queue<FutureTask<?>> queue = futureTaskQueue;
            synchronized (queue) {
                futureTaskQueue.add((FutureTask<?>)listenableFutureTask);
                return listenableFutureTask;
            }
        }
        try {
            return Futures.immediateFuture(callable.call());
        }
        catch (Exception e) {
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
    }

    public static ListenableFuture<Object> addScheduledTask(Runnable runnableToSchedule) {
        Validate.notNull((Object)runnableToSchedule);
        return ServerThreadUtil.callFromMainThread(Executors.callable(runnableToSchedule));
    }
}

