/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.data;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface ImmutableItemMeta {
    @Nonnull
    public Item getItem();

    public int getItemMeta();

    default public Block getBlock() {
        return Block.getBlockFromItem((Item)this.getItem());
    }

    default public boolean matches(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.matches(stack.getItem(), Items.feather.getDamage(stack));
    }

    default public boolean matches(Item item, int meta) {
        return this.getItem() == item && (meta == Short.MAX_VALUE || this.getItemMeta() == Short.MAX_VALUE || this.getItemMeta() == meta);
    }

    default public ItemStack toStack(int amount) {
        int meta = this.getItemMeta();
        return new ItemStack(this.getItem(), amount, meta == Short.MAX_VALUE ? 0 : meta);
    }
}

