/*
 * The MIT License
 *
 * Copyright (c) 2022-2024 Kai Burjack
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.joml;

//#ifdef __HAS_JVMCI__
/// import jdk.vm.ci.amd64.AMD64;
/// import jdk.vm.ci.code.Architecture;
/// import jdk.vm.ci.code.CodeCacheProvider;
/// import jdk.vm.ci.code.CompiledCode;
/// import jdk.vm.ci.code.TargetDescription;
/// import jdk.vm.ci.code.site.DataPatch;
/// import jdk.vm.ci.code.site.Site;
/// import jdk.vm.ci.hotspot.HotSpotCompiledCode;
/// import jdk.vm.ci.hotspot.HotSpotCompiledNmethod;
/// import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
/// import jdk.vm.ci.meta.Assumptions;
/// import jdk.vm.ci.meta.ResolvedJavaMethod;
/// import jdk.vm.ci.runtime.JVMCI;
/// import jdk.vm.ci.runtime.JVMCIBackend;
/// import jdk.vm.ci.runtime.JVMCICompiler;
/// import jdk.vm.ci.runtime.JVMCIRuntime;

/// import java.lang.reflect.Field;
/// import java.lang.reflect.Method;
/// import java.util.Set;

/// class JvmciCode {
  /// static final boolean canUseJvmci;

  /// static final byte[] MATRIX4D_MUL_AVX_LINUX = {
          /// (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x62, (byte) 0x10,
          /// (byte) 0xC5, (byte) 0xFD, (byte) 0x10, (byte) 0x5E, (byte) 0x10, (byte) 0xC5, (byte) 0xFD, (byte) 0x10,
          /// (byte) 0x56, (byte) 0x30, (byte) 0xC5, (byte) 0xFD, (byte) 0x10, (byte) 0x4E, (byte) 0x50, (byte) 0xC5,
          /// (byte) 0xFD, (byte) 0x10, (byte) 0x46, (byte) 0x70, (byte) 0xC5, (byte) 0xDD, (byte) 0x59, (byte) 0xE3,
          /// (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x6A, (byte) 0x18, (byte) 0xC4, (byte) 0xE2,
          /// (byte) 0xED, (byte) 0xA8, (byte) 0xEC, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x72,
          /// (byte) 0x20, (byte) 0xC4, (byte) 0xE2, (byte) 0xF5, (byte) 0xA8, (byte) 0xF5, (byte) 0xC4, (byte) 0xE2,
          /// (byte) 0x7D, (byte) 0x19, (byte) 0x62, (byte) 0x28, (byte) 0xC4, (byte) 0xE2, (byte) 0xFD, (byte) 0xA8,
          /// (byte) 0xE6, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x6A, (byte) 0x30, (byte) 0xC5,
          /// (byte) 0xD5, (byte) 0x59, (byte) 0xEB, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x72,
          /// (byte) 0x38, (byte) 0xC4, (byte) 0xE2, (byte) 0xED, (byte) 0xA8, (byte) 0xF5, (byte) 0xC4, (byte) 0xE2,
          /// (byte) 0x7D, (byte) 0x19, (byte) 0x6A, (byte) 0x40, (byte) 0xC4, (byte) 0xE2, (byte) 0xF5, (byte) 0xA8,
          /// (byte) 0xEE, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x72, (byte) 0x48, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0xFD, (byte) 0xA8, (byte) 0xF5, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19,
          /// (byte) 0x6A, (byte) 0x50, (byte) 0xC5, (byte) 0xD5, (byte) 0x59, (byte) 0xEB, (byte) 0xC4, (byte) 0xE2,
          /// (byte) 0x7D, (byte) 0x19, (byte) 0x7A, (byte) 0x58, (byte) 0xC4, (byte) 0xE2, (byte) 0xED, (byte) 0xA8,
          /// (byte) 0xFD, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x6A, (byte) 0x60, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0xF5, (byte) 0xA8, (byte) 0xEF, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19,
          /// (byte) 0x7A, (byte) 0x68, (byte) 0xC4, (byte) 0xE2, (byte) 0xFD, (byte) 0xA8, (byte) 0xFD, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x6A, (byte) 0x70, (byte) 0xC5, (byte) 0xD5, (byte) 0x59,
          /// (byte) 0xDB, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x6A, (byte) 0x78, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0xED, (byte) 0xA8, (byte) 0xEB, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19,
          /// (byte) 0x92, (byte) 0x80, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0xC4, (byte) 0xE2, (byte) 0xF5,
          /// (byte) 0xA8, (byte) 0xD5, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x19, (byte) 0x8A, (byte) 0x88,
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0xC4, (byte) 0xE2, (byte) 0xFD, (byte) 0xA8, (byte) 0xCA,
          /// (byte) 0xC5, (byte) 0xFD, (byte) 0x11, (byte) 0x61, (byte) 0x10, (byte) 0xC5, (byte) 0xFD, (byte) 0x11,
          /// (byte) 0x71, (byte) 0x30, (byte) 0xC5, (byte) 0xFD, (byte) 0x11, (byte) 0x79, (byte) 0x50, (byte) 0xC5,
          /// (byte) 0xFD, (byte) 0x11, (byte) 0x49, (byte) 0x70, (byte) 0xC5, (byte) 0xF8, (byte) 0x77, (byte) 0xC3 };
  /// static final byte[] MATRIX4D_MUL_AVX_WINDOWS = {
          /// (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x60, (byte) 0x10,
          /// (byte) 0xC5, (byte) 0xFD, (byte) 0x10, (byte) 0x5A, (byte) 0x10, (byte) 0xC5, (byte) 0xFD, (byte) 0x10,
          /// (byte) 0x52, (byte) 0x30, (byte) 0xC5, (byte) 0xFD, (byte) 0x10, (byte) 0x4A, (byte) 0x50, (byte) 0xC5,
          /// (byte) 0xFD, (byte) 0x10, (byte) 0x42, (byte) 0x70, (byte) 0xC5, (byte) 0xDD, (byte) 0x59, (byte) 0xE3,
          /// (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x68, (byte) 0x18, (byte) 0xC4, (byte) 0xE2,
          /// (byte) 0xED, (byte) 0xA8, (byte) 0xEC, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x70,
          /// (byte) 0x20, (byte) 0xC4, (byte) 0xE2, (byte) 0xF5, (byte) 0xA8, (byte) 0xF5, (byte) 0xC4, (byte) 0xC2,
          /// (byte) 0x7D, (byte) 0x19, (byte) 0x60, (byte) 0x28, (byte) 0xC4, (byte) 0xE2, (byte) 0xFD, (byte) 0xA8,
          /// (byte) 0xE6, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x68, (byte) 0x30, (byte) 0xC5,
          /// (byte) 0xD5, (byte) 0x59, (byte) 0xEB, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x70,
          /// (byte) 0x38, (byte) 0xC4, (byte) 0xE2, (byte) 0xED, (byte) 0xA8, (byte) 0xF5, (byte) 0xC4, (byte) 0xC2,
          /// (byte) 0x7D, (byte) 0x19, (byte) 0x68, (byte) 0x40, (byte) 0xC4, (byte) 0xE2, (byte) 0xF5, (byte) 0xA8,
          /// (byte) 0xEE, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x70, (byte) 0x48, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0xFD, (byte) 0xA8, (byte) 0xF5, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19,
          /// (byte) 0x68, (byte) 0x50, (byte) 0xC5, (byte) 0xD5, (byte) 0x59, (byte) 0xEB, (byte) 0xC4, (byte) 0xC2,
          /// (byte) 0x7D, (byte) 0x19, (byte) 0x78, (byte) 0x58, (byte) 0xC4, (byte) 0xE2, (byte) 0xED, (byte) 0xA8,
          /// (byte) 0xFD, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x68, (byte) 0x60, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0xF5, (byte) 0xA8, (byte) 0xEF, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19,
          /// (byte) 0x78, (byte) 0x68, (byte) 0xC4, (byte) 0xE2, (byte) 0xFD, (byte) 0xA8, (byte) 0xFD, (byte) 0xC4,
          /// (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x68, (byte) 0x70, (byte) 0xC5, (byte) 0xD5, (byte) 0x59,
          /// (byte) 0xDB, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x68, (byte) 0x78, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0xED, (byte) 0xA8, (byte) 0xEB, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19,
          /// (byte) 0x90, (byte) 0x80, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0xC4, (byte) 0xE2, (byte) 0xF5,
          /// (byte) 0xA8, (byte) 0xD5, (byte) 0xC4, (byte) 0xC2, (byte) 0x7D, (byte) 0x19, (byte) 0x88, (byte) 0x88,
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0xC4, (byte) 0xE2, (byte) 0xFD, (byte) 0xA8, (byte) 0xCA,
          /// (byte) 0xC4, (byte) 0xC1, (byte) 0x7D, (byte) 0x11, (byte) 0x61, (byte) 0x10, (byte) 0xC4, (byte) 0xC1,
          /// (byte) 0x7D, (byte) 0x11, (byte) 0x71, (byte) 0x30, (byte) 0xC4, (byte) 0xC1, (byte) 0x7D, (byte) 0x11,
          /// (byte) 0x79, (byte) 0x50, (byte) 0xC4, (byte) 0xC1, (byte) 0x7D, (byte) 0x11, (byte) 0x49, (byte) 0x70,
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x77, (byte) 0xC3 };

  /// static final byte[] MATRIX4F_MUL_AVX_LINUX = {
          /// (byte) 0xC5, (byte) 0xFC, (byte) 0x10, (byte) 0x42, (byte) 0x10, (byte) 0xC5,
          /// (byte) 0xFC, (byte) 0x10, (byte) 0x4A, (byte) 0x30, (byte) 0xC4, (byte) 0xE3, (byte) 0x7D, (byte) 0x04,
          /// (byte) 0xD0, (byte) 0x00, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x1A, (byte) 0x5E, (byte) 0x10,
          /// (byte) 0xC5, (byte) 0xE4, (byte) 0x59, (byte) 0xD2, (byte) 0xC4, (byte) 0xE3, (byte) 0x7D, (byte) 0x04,
          /// (byte) 0xE0, (byte) 0x55, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x1A, (byte) 0x6E, (byte) 0x20,
          /// (byte) 0xC4, (byte) 0xE2, (byte) 0x55, (byte) 0xA8, (byte) 0xE2, (byte) 0xC4, (byte) 0xE3, (byte) 0x7D,
          /// (byte) 0x04, (byte) 0xD0, (byte) 0xAA, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x1A, (byte) 0x76,
          /// (byte) 0x30, (byte) 0xC4, (byte) 0xE2, (byte) 0x4D, (byte) 0xA8, (byte) 0xD4, (byte) 0xC4, (byte) 0xE3,
          /// (byte) 0x7D, (byte) 0x04, (byte) 0xC0, (byte) 0xFF, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x1A,
          /// (byte) 0x66, (byte) 0x40, (byte) 0xC4, (byte) 0xE2, (byte) 0x5D, (byte) 0xA8, (byte) 0xC2, (byte) 0xC4,
          /// (byte) 0xE3, (byte) 0x7D, (byte) 0x04, (byte) 0xD1, (byte) 0x00, (byte) 0xC5, (byte) 0xE4, (byte) 0x59,
          /// (byte) 0xD2, (byte) 0xC4, (byte) 0xE3, (byte) 0x7D, (byte) 0x04, (byte) 0xD9, (byte) 0x55, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0x55, (byte) 0xA8, (byte) 0xDA, (byte) 0xC4, (byte) 0xE3, (byte) 0x7D, (byte) 0x04,
          /// (byte) 0xD1, (byte) 0xAA, (byte) 0xC4, (byte) 0xE2, (byte) 0x4D, (byte) 0xA8, (byte) 0xD3, (byte) 0xC4,
          /// (byte) 0xE3, (byte) 0x7D, (byte) 0x04, (byte) 0xC9, (byte) 0xFF, (byte) 0xC4, (byte) 0xE2, (byte) 0x5D,
          /// (byte) 0xA8, (byte) 0xCA, (byte) 0xC5, (byte) 0xFC, (byte) 0x11, (byte) 0x41, (byte) 0x10, (byte) 0xC5,
          /// (byte) 0xFC, (byte) 0x11, (byte) 0x49, (byte) 0x30, (byte) 0xC5, (byte) 0xF8, (byte) 0x77, (byte) 0xC3 };
  /// static final byte[] MATRIX4F_MUL_AVX_WINDOWS = {
          /// (byte) 0xC4, (byte) 0xC1, (byte) 0x7C, (byte) 0x10, (byte) 0x40, (byte) 0x10,
          /// (byte) 0xC4, (byte) 0xC1, (byte) 0x7C, (byte) 0x10, (byte) 0x48, (byte) 0x30, (byte) 0xC4, (byte) 0xE3,
          /// (byte) 0x7D, (byte) 0x04, (byte) 0xD0, (byte) 0x00, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x1A,
          /// (byte) 0x5A, (byte) 0x10, (byte) 0xC5, (byte) 0xE4, (byte) 0x59, (byte) 0xD2, (byte) 0xC4, (byte) 0xE3,
          /// (byte) 0x7D, (byte) 0x04, (byte) 0xE0, (byte) 0x55, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D, (byte) 0x1A,
          /// (byte) 0x6A, (byte) 0x20, (byte) 0xC4, (byte) 0xE2, (byte) 0x55, (byte) 0xA8, (byte) 0xE2, (byte) 0xC4,
          /// (byte) 0xE3, (byte) 0x7D, (byte) 0x04, (byte) 0xD0, (byte) 0xAA, (byte) 0xC4, (byte) 0xE2, (byte) 0x7D,
          /// (byte) 0x1A, (byte) 0x72, (byte) 0x30, (byte) 0xC4, (byte) 0xE2, (byte) 0x4D, (byte) 0xA8, (byte) 0xD4,
          /// (byte) 0xC4, (byte) 0xE3, (byte) 0x7D, (byte) 0x04, (byte) 0xC0, (byte) 0xFF, (byte) 0xC4, (byte) 0xE2,
          /// (byte) 0x7D, (byte) 0x1A, (byte) 0x62, (byte) 0x40, (byte) 0xC4, (byte) 0xE2, (byte) 0x5D, (byte) 0xA8,
          /// (byte) 0xC2, (byte) 0xC4, (byte) 0xE3, (byte) 0x7D, (byte) 0x04, (byte) 0xD1, (byte) 0x00, (byte) 0xC5,
          /// (byte) 0xE4, (byte) 0x59, (byte) 0xD2, (byte) 0xC4, (byte) 0xE3, (byte) 0x7D, (byte) 0x04, (byte) 0xD9,
          /// (byte) 0x55, (byte) 0xC4, (byte) 0xE2, (byte) 0x55, (byte) 0xA8, (byte) 0xDA, (byte) 0xC4, (byte) 0xE3,
          /// (byte) 0x7D, (byte) 0x04, (byte) 0xD1, (byte) 0xAA, (byte) 0xC4, (byte) 0xE2, (byte) 0x4D, (byte) 0xA8,
          /// (byte) 0xD3, (byte) 0xC4, (byte) 0xE3, (byte) 0x7D, (byte) 0x04, (byte) 0xC9, (byte) 0xFF, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0x5D, (byte) 0xA8, (byte) 0xCA, (byte) 0xC4, (byte) 0xC1, (byte) 0x7C, (byte) 0x11,
          /// (byte) 0x41, (byte) 0x10, (byte) 0xC4, (byte) 0xC1, (byte) 0x7C, (byte) 0x11, (byte) 0x49, (byte) 0x30,
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x77, (byte) 0xC3 };

  /// static final byte[] MATRIX4F_INVERT_AVX_LINUX = {
          /// (byte) 0xC5, (byte) 0xFB, (byte) 0x10, (byte) 0x46, (byte) 0x10, (byte) 0xC5,
          /// (byte) 0xFB, (byte) 0x10, (byte) 0x66, (byte) 0x18, (byte) 0xC5, (byte) 0xFB, (byte) 0x10, (byte) 0x4E,
          /// (byte) 0x30, (byte) 0xC5, (byte) 0xFB, (byte) 0x10, (byte) 0x6E, (byte) 0x38, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x16, (byte) 0x56, (byte) 0x20, (byte) 0xC5, (byte) 0xF0, (byte) 0x16, (byte) 0x5E, (byte) 0x40,
          /// (byte) 0xC5, (byte) 0xE8, (byte) 0xC6, (byte) 0xC3, (byte) 0x88, (byte) 0xC5, (byte) 0xE0, (byte) 0xC6,
          /// (byte) 0xCA, (byte) 0xDD, (byte) 0xC5, (byte) 0xD8, (byte) 0x16, (byte) 0x76, (byte) 0x28, (byte) 0xC5,
          /// (byte) 0x50, (byte) 0x16, (byte) 0x46, (byte) 0x48, (byte) 0xC4, (byte) 0xC1, (byte) 0x48, (byte) 0xC6,
          /// (byte) 0xF8, (byte) 0x88, (byte) 0xC5, (byte) 0xB8, (byte) 0xC6, (byte) 0xE6, (byte) 0xDD, (byte) 0xC5,
          /// (byte) 0xD8, (byte) 0x59, (byte) 0xEF, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xED,
          /// (byte) 0xB1, (byte) 0xC4, (byte) 0x63, (byte) 0x79, (byte) 0x05, (byte) 0xCD, (byte) 0x01, (byte) 0xC5,
          /// (byte) 0xB0, (byte) 0x5C, (byte) 0xED, (byte) 0xC5, (byte) 0x50, (byte) 0x59, (byte) 0xD9, (byte) 0xC5,
          /// (byte) 0x40, (byte) 0x59, (byte) 0xC9, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x04, (byte) 0xC9,
          /// (byte) 0xB1, (byte) 0xC5, (byte) 0x30, (byte) 0x59, (byte) 0xE4, (byte) 0xC4, (byte) 0x43, (byte) 0x79,
          /// (byte) 0x05, (byte) 0xE9, (byte) 0x01, (byte) 0xC4, (byte) 0x41, (byte) 0x10, (byte) 0x5C, (byte) 0xC9,
          /// (byte) 0xC5, (byte) 0x78, (byte) 0x29, (byte) 0x4C, (byte) 0x24, (byte) 0xE8, (byte) 0xC5, (byte) 0x68,
          /// (byte) 0xC6, (byte) 0xD3, (byte) 0x77, (byte) 0xC5, (byte) 0x38, (byte) 0xC6, (byte) 0xF6, (byte) 0x77,
          /// (byte) 0xC4, (byte) 0x41, (byte) 0x08, (byte) 0x59, (byte) 0xF2, (byte) 0xC4, (byte) 0x63, (byte) 0x79,
          /// (byte) 0x05, (byte) 0xD7, (byte) 0x01, (byte) 0xC4, (byte) 0xC1, (byte) 0x08, (byte) 0x59, (byte) 0xFA,
          /// (byte) 0xC5, (byte) 0x98, (byte) 0x58, (byte) 0xFF, (byte) 0xC5, (byte) 0xA0, (byte) 0x58, (byte) 0xFF,
          /// (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x05, (byte) 0xDE, (byte) 0x01, (byte) 0xC5, (byte) 0x10,
          /// (byte) 0x59, (byte) 0xE4, (byte) 0xC4, (byte) 0x41, (byte) 0x20, (byte) 0x59, (byte) 0xEA, (byte) 0xC4,
          /// (byte) 0x41, (byte) 0x18, (byte) 0x58, (byte) 0xE5, (byte) 0xC4, (byte) 0xC1, (byte) 0x40, (byte) 0x5C,
          /// (byte) 0xFC, (byte) 0xC4, (byte) 0x41, (byte) 0x20, (byte) 0x5C, (byte) 0xDE, (byte) 0xC5, (byte) 0x20,
          /// (byte) 0x59, (byte) 0xD8, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x05, (byte) 0xDB, (byte) 0x01,
          /// (byte) 0xC5, (byte) 0x70, (byte) 0x59, (byte) 0xE0, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x04,
          /// (byte) 0xE4, (byte) 0xB1, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x05, (byte) 0xEC, (byte) 0x01,
          /// (byte) 0xC5, (byte) 0x58, (byte) 0x59, (byte) 0xF0, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x04,
          /// (byte) 0xF6, (byte) 0xB1, (byte) 0xC4, (byte) 0x41, (byte) 0x10, (byte) 0x5C, (byte) 0xFC, (byte) 0xC5,
          /// (byte) 0x00, (byte) 0x59, (byte) 0xFC, (byte) 0xC4, (byte) 0x41, (byte) 0x00, (byte) 0x5C, (byte) 0xDB,
          /// (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x05, (byte) 0xFE, (byte) 0x01, (byte) 0xC4, (byte) 0x41,
          /// (byte) 0x08, (byte) 0x5C, (byte) 0xCF, (byte) 0xC5, (byte) 0x30, (byte) 0x59, (byte) 0xC9, (byte) 0xC4,
          /// (byte) 0x41, (byte) 0x20, (byte) 0x58, (byte) 0xC9, (byte) 0xC5, (byte) 0xE8, (byte) 0xC6, (byte) 0xD3,
          /// (byte) 0x22, (byte) 0xC5, (byte) 0xB8, (byte) 0xC6, (byte) 0xDE, (byte) 0x22, (byte) 0xC5, (byte) 0xE0,
          /// (byte) 0x59, (byte) 0xD2, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x05, (byte) 0xDA, (byte) 0x01,
          /// (byte) 0xC5, (byte) 0xE8, (byte) 0x5C, (byte) 0xF3, (byte) 0xC5, (byte) 0xC8, (byte) 0x59, (byte) 0xE4,
          /// (byte) 0xC4, (byte) 0xC1, (byte) 0x00, (byte) 0x5C, (byte) 0xF6, (byte) 0xC5, (byte) 0xA8, (byte) 0x59,
          /// (byte) 0xF6, (byte) 0xC5, (byte) 0xC8, (byte) 0x58, (byte) 0xE4, (byte) 0xC5, (byte) 0xD0, (byte) 0x59,
          /// (byte) 0xE8, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x05, (byte) 0xED, (byte) 0x01, (byte) 0xC5,
          /// (byte) 0xD0, (byte) 0x58, (byte) 0xE4, (byte) 0xC5, (byte) 0xE0, (byte) 0x5C, (byte) 0xD2, (byte) 0xC5,
          /// (byte) 0xE8, (byte) 0x59, (byte) 0xC9, (byte) 0xC4, (byte) 0xC1, (byte) 0x18, (byte) 0x5C, (byte) 0xD5,
          /// (byte) 0xC5, (byte) 0xA8, (byte) 0x59, (byte) 0xD2, (byte) 0xC5, (byte) 0xF8, (byte) 0x59, (byte) 0x5C,
          /// (byte) 0x24, (byte) 0xE8, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x05, (byte) 0xDB, (byte) 0x01,
          /// (byte) 0xC5, (byte) 0xE8, (byte) 0x5C, (byte) 0xD3, (byte) 0xC5, (byte) 0xE8, (byte) 0x58, (byte) 0xC9,
          /// (byte) 0xC5, (byte) 0xC0, (byte) 0x59, (byte) 0xC0, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x05,
          /// (byte) 0xD0, (byte) 0x01, (byte) 0xC5, (byte) 0xE8, (byte) 0x58, (byte) 0xC0, (byte) 0xC5, (byte) 0xFA,
          /// (byte) 0x16, (byte) 0xD0, (byte) 0xC5, (byte) 0xF8, (byte) 0x58, (byte) 0xC2, (byte) 0xC5, (byte) 0xFA,
          /// (byte) 0x53, (byte) 0xD0, (byte) 0xC5, (byte) 0xEA, (byte) 0x59, (byte) 0xDA, (byte) 0xC5, (byte) 0xE2,
          /// (byte) 0x59, (byte) 0xC0, (byte) 0xC5, (byte) 0xEA, (byte) 0x58, (byte) 0xD2, (byte) 0xC5, (byte) 0xEA,
          /// (byte) 0x5C, (byte) 0xC0, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xC0, (byte) 0x00,
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x59, (byte) 0xD4, (byte) 0xC5, (byte) 0xF8, (byte) 0x11, (byte) 0x52,
          /// (byte) 0x20, (byte) 0xC5, (byte) 0xF8, (byte) 0x59, (byte) 0xD7, (byte) 0xC5, (byte) 0xF8, (byte) 0x11,
          /// (byte) 0x52, (byte) 0x10, (byte) 0xC5, (byte) 0xB0, (byte) 0x59, (byte) 0xD0, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x59, (byte) 0xC1, (byte) 0xC5, (byte) 0xF8, (byte) 0x11, (byte) 0x42, (byte) 0x40, (byte) 0xC5,
          /// (byte) 0xF8, (byte) 0x11, (byte) 0x52, (byte) 0x30, (byte) 0xC3 };
  /// static final byte[] MATRIX4F_INVERT_AVX_WINDOWS = {
          /// (byte) 0xC5, (byte) 0xFB, (byte) 0x10, (byte) 0x42, (byte) 0x10, (byte) 0xC5,
          /// (byte) 0xFB, (byte) 0x10, (byte) 0x62, (byte) 0x18, (byte) 0xC5, (byte) 0xFB, (byte) 0x10, (byte) 0x4A,
          /// (byte) 0x30, (byte) 0xC5, (byte) 0xFB, (byte) 0x10, (byte) 0x6A, (byte) 0x38, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x16, (byte) 0x52, (byte) 0x20, (byte) 0xC5, (byte) 0xF0, (byte) 0x16, (byte) 0x5A, (byte) 0x40,
          /// (byte) 0xC5, (byte) 0xE8, (byte) 0xC6, (byte) 0xC3, (byte) 0x88, (byte) 0xC5, (byte) 0xE0, (byte) 0xC6,
          /// (byte) 0xCA, (byte) 0xDD, (byte) 0xC5, (byte) 0xD8, (byte) 0x16, (byte) 0x72, (byte) 0x28, (byte) 0xC5,
          /// (byte) 0x50, (byte) 0x16, (byte) 0x42, (byte) 0x48, (byte) 0xC4, (byte) 0xC1, (byte) 0x48, (byte) 0xC6,
          /// (byte) 0xF8, (byte) 0x88, (byte) 0xC5, (byte) 0xB8, (byte) 0xC6, (byte) 0xE6, (byte) 0xDD, (byte) 0xC5,
          /// (byte) 0xD8, (byte) 0x59, (byte) 0xEF, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xED,
          /// (byte) 0xB1, (byte) 0xC4, (byte) 0x63, (byte) 0x79, (byte) 0x05, (byte) 0xCD, (byte) 0x01, (byte) 0xC5,
          /// (byte) 0xB0, (byte) 0x5C, (byte) 0xED, (byte) 0xC5, (byte) 0x50, (byte) 0x59, (byte) 0xD9, (byte) 0xC5,
          /// (byte) 0x40, (byte) 0x59, (byte) 0xC9, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x04, (byte) 0xC9,
          /// (byte) 0xB1, (byte) 0xC5, (byte) 0x30, (byte) 0x59, (byte) 0xE4, (byte) 0xC4, (byte) 0x43, (byte) 0x79,
          /// (byte) 0x05, (byte) 0xE9, (byte) 0x01, (byte) 0xC4, (byte) 0x41, (byte) 0x10, (byte) 0x5C, (byte) 0xC9,
          /// (byte) 0xC5, (byte) 0x78, (byte) 0x29, (byte) 0x4C, (byte) 0x24, (byte) 0xE8, (byte) 0xC5, (byte) 0x68,
          /// (byte) 0xC6, (byte) 0xD3, (byte) 0x77, (byte) 0xC5, (byte) 0x38, (byte) 0xC6, (byte) 0xF6, (byte) 0x77,
          /// (byte) 0xC4, (byte) 0x41, (byte) 0x08, (byte) 0x59, (byte) 0xF2, (byte) 0xC4, (byte) 0x63, (byte) 0x79,
          /// (byte) 0x05, (byte) 0xD7, (byte) 0x01, (byte) 0xC4, (byte) 0xC1, (byte) 0x08, (byte) 0x59, (byte) 0xFA,
          /// (byte) 0xC5, (byte) 0x98, (byte) 0x58, (byte) 0xFF, (byte) 0xC5, (byte) 0xA0, (byte) 0x58, (byte) 0xFF,
          /// (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x05, (byte) 0xDE, (byte) 0x01, (byte) 0xC5, (byte) 0x10,
          /// (byte) 0x59, (byte) 0xE4, (byte) 0xC4, (byte) 0x41, (byte) 0x20, (byte) 0x59, (byte) 0xEA, (byte) 0xC4,
          /// (byte) 0x41, (byte) 0x18, (byte) 0x58, (byte) 0xE5, (byte) 0xC4, (byte) 0xC1, (byte) 0x40, (byte) 0x5C,
          /// (byte) 0xFC, (byte) 0xC4, (byte) 0x41, (byte) 0x20, (byte) 0x5C, (byte) 0xDE, (byte) 0xC5, (byte) 0x20,
          /// (byte) 0x59, (byte) 0xD8, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x05, (byte) 0xDB, (byte) 0x01,
          /// (byte) 0xC5, (byte) 0x70, (byte) 0x59, (byte) 0xE0, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x04,
          /// (byte) 0xE4, (byte) 0xB1, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x05, (byte) 0xEC, (byte) 0x01,
          /// (byte) 0xC5, (byte) 0x58, (byte) 0x59, (byte) 0xF0, (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x04,
          /// (byte) 0xF6, (byte) 0xB1, (byte) 0xC4, (byte) 0x41, (byte) 0x10, (byte) 0x5C, (byte) 0xFC, (byte) 0xC5,
          /// (byte) 0x00, (byte) 0x59, (byte) 0xFC, (byte) 0xC4, (byte) 0x41, (byte) 0x00, (byte) 0x5C, (byte) 0xDB,
          /// (byte) 0xC4, (byte) 0x43, (byte) 0x79, (byte) 0x05, (byte) 0xFE, (byte) 0x01, (byte) 0xC4, (byte) 0x41,
          /// (byte) 0x08, (byte) 0x5C, (byte) 0xCF, (byte) 0xC5, (byte) 0x30, (byte) 0x59, (byte) 0xC9, (byte) 0xC4,
          /// (byte) 0x41, (byte) 0x20, (byte) 0x58, (byte) 0xC9, (byte) 0xC5, (byte) 0xE8, (byte) 0xC6, (byte) 0xD3,
          /// (byte) 0x22, (byte) 0xC5, (byte) 0xB8, (byte) 0xC6, (byte) 0xDE, (byte) 0x22, (byte) 0xC5, (byte) 0xE0,
          /// (byte) 0x59, (byte) 0xD2, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x05, (byte) 0xDA, (byte) 0x01,
          /// (byte) 0xC5, (byte) 0xE8, (byte) 0x5C, (byte) 0xF3, (byte) 0xC5, (byte) 0xC8, (byte) 0x59, (byte) 0xE4,
          /// (byte) 0xC4, (byte) 0xC1, (byte) 0x00, (byte) 0x5C, (byte) 0xF6, (byte) 0xC5, (byte) 0xA8, (byte) 0x59,
          /// (byte) 0xF6, (byte) 0xC5, (byte) 0xC8, (byte) 0x58, (byte) 0xE4, (byte) 0xC5, (byte) 0xD0, (byte) 0x59,
          /// (byte) 0xE8, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x05, (byte) 0xED, (byte) 0x01, (byte) 0xC5,
          /// (byte) 0xD0, (byte) 0x58, (byte) 0xE4, (byte) 0xC5, (byte) 0xE0, (byte) 0x5C, (byte) 0xD2, (byte) 0xC5,
          /// (byte) 0xE8, (byte) 0x59, (byte) 0xC9, (byte) 0xC4, (byte) 0xC1, (byte) 0x18, (byte) 0x5C, (byte) 0xD5,
          /// (byte) 0xC5, (byte) 0xA8, (byte) 0x59, (byte) 0xD2, (byte) 0xC5, (byte) 0xF8, (byte) 0x59, (byte) 0x5C,
          /// (byte) 0x24, (byte) 0xE8, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x05, (byte) 0xDB, (byte) 0x01,
          /// (byte) 0xC5, (byte) 0xE8, (byte) 0x5C, (byte) 0xD3, (byte) 0xC5, (byte) 0xE8, (byte) 0x58, (byte) 0xC9,
          /// (byte) 0xC5, (byte) 0xC0, (byte) 0x59, (byte) 0xC0, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x05,
          /// (byte) 0xD0, (byte) 0x01, (byte) 0xC5, (byte) 0xE8, (byte) 0x58, (byte) 0xC0, (byte) 0xC5, (byte) 0xFA,
          /// (byte) 0x16, (byte) 0xD0, (byte) 0xC5, (byte) 0xF8, (byte) 0x58, (byte) 0xC2, (byte) 0xC5, (byte) 0xFA,
          /// (byte) 0x53, (byte) 0xD0, (byte) 0xC5, (byte) 0xEA, (byte) 0x59, (byte) 0xDA, (byte) 0xC5, (byte) 0xE2,
          /// (byte) 0x59, (byte) 0xC0, (byte) 0xC5, (byte) 0xEA, (byte) 0x58, (byte) 0xD2, (byte) 0xC5, (byte) 0xEA,
          /// (byte) 0x5C, (byte) 0xC0, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xC0, (byte) 0x00,
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x59, (byte) 0xD4, (byte) 0xC4, (byte) 0xC1, (byte) 0x78, (byte) 0x11,
          /// (byte) 0x50, (byte) 0x20, (byte) 0xC5, (byte) 0xF8, (byte) 0x59, (byte) 0xD7, (byte) 0xC4, (byte) 0xC1,
          /// (byte) 0x78, (byte) 0x11, (byte) 0x50, (byte) 0x10, (byte) 0xC5, (byte) 0xB0, (byte) 0x59, (byte) 0xD0,
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x59, (byte) 0xC1, (byte) 0xC4, (byte) 0xC1, (byte) 0x78, (byte) 0x11,
          /// (byte) 0x40, (byte) 0x40, (byte) 0xC4, (byte) 0xC1, (byte) 0x78, (byte) 0x11, (byte) 0x50, (byte) 0x30,
          /// (byte) 0xC3 };

  /// static final byte[] MATRIX4F_TRANSPOSE_AVX_LINUX = {
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x10, (byte) 0x46, (byte) 0x10, (byte) 0xC5,
          /// (byte) 0xF8, (byte) 0x10, (byte) 0x4E, (byte) 0x20, (byte) 0xC5, (byte) 0xF8, (byte) 0x10, (byte) 0x56,
          /// (byte) 0x30, (byte) 0xC5, (byte) 0xF8, (byte) 0x10, (byte) 0x5E, (byte) 0x40, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x14, (byte) 0xE1, (byte) 0xC5, (byte) 0xE8, (byte) 0x14, (byte) 0xEB, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x15, (byte) 0xC1, (byte) 0xC5, (byte) 0xE8, (byte) 0x15, (byte) 0xCB, (byte) 0xC5, (byte) 0xD8,
          /// (byte) 0x16, (byte) 0xD5, (byte) 0xC5, (byte) 0xD9, (byte) 0x15, (byte) 0xDD, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x16, (byte) 0xE1, (byte) 0xC5, (byte) 0xF9, (byte) 0x15, (byte) 0xC1, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x11, (byte) 0x52, (byte) 0x10, (byte) 0xC5, (byte) 0xF8, (byte) 0x11, (byte) 0x5A, (byte) 0x20,
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x11, (byte) 0x62, (byte) 0x30, (byte) 0xC5, (byte) 0xF8, (byte) 0x11,
          /// (byte) 0x42, (byte) 0x40, (byte) 0xC3 };
  /// static final byte[] MATRIX4F_TRANSPOSE_AVX_WINDOWS = {
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x10, (byte) 0x42, (byte) 0x10, (byte) 0xC5,
          /// (byte) 0xF8, (byte) 0x10, (byte) 0x4A, (byte) 0x20, (byte) 0xC5, (byte) 0xF8, (byte) 0x10, (byte) 0x52,
          /// (byte) 0x30, (byte) 0xC5, (byte) 0xF8, (byte) 0x10, (byte) 0x5A, (byte) 0x40, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x14, (byte) 0xE1, (byte) 0xC5, (byte) 0xE8, (byte) 0x14, (byte) 0xEB, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x15, (byte) 0xC1, (byte) 0xC5, (byte) 0xE8, (byte) 0x15, (byte) 0xCB, (byte) 0xC5, (byte) 0xD8,
          /// (byte) 0x16, (byte) 0xD5, (byte) 0xC5, (byte) 0xD9, (byte) 0x15, (byte) 0xDD, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x16, (byte) 0xE1, (byte) 0xC5, (byte) 0xF9, (byte) 0x15, (byte) 0xC1, (byte) 0xC4, (byte) 0xC1,
          /// (byte) 0x78, (byte) 0x11, (byte) 0x50, (byte) 0x10, (byte) 0xC4, (byte) 0xC1, (byte) 0x78, (byte) 0x11,
          /// (byte) 0x58, (byte) 0x20, (byte) 0xC4, (byte) 0xC1, (byte) 0x78, (byte) 0x11, (byte) 0x60, (byte) 0x30,
          /// (byte) 0xC4, (byte) 0xC1, (byte) 0x78, (byte) 0x11, (byte) 0x40, (byte) 0x40, (byte) 0xC3 };

  /// static final byte[] MATRIX4F_SET_AVX_LINUX = {
          /// (byte) 0xC5, (byte) 0xFC, (byte) 0x10, (byte) 0x46, (byte) 0x10, (byte) 0xC5,
          /// (byte) 0xFC, (byte) 0x10, (byte) 0x4E, (byte) 0x30, (byte) 0xC5, (byte) 0xFC, (byte) 0x11, (byte) 0x42,
          /// (byte) 0x10, (byte) 0xC5, (byte) 0xFC, (byte) 0x11, (byte) 0x4A, (byte) 0x30, (byte) 0xC5, (byte) 0xF8,
          /// (byte) 0x77, (byte) 0xC3 };
  /// static final byte[] MATRIX4F_SET_AVX_WINDOWS = {
          /// (byte) 0xC5, (byte) 0xFC, (byte) 0x10, (byte) 0x42, (byte) 0x10, (byte) 0xC5,
          /// (byte) 0xFC, (byte) 0x10, (byte) 0x4A, (byte) 0x30, (byte) 0xC4, (byte) 0xC1, (byte) 0x7C, (byte) 0x11,
          /// (byte) 0x40, (byte) 0x10, (byte) 0xC4, (byte) 0xC1, (byte) 0x7C, (byte) 0x11, (byte) 0x48, (byte) 0x30,
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x77, (byte) 0xC3 };

  /// static final byte[] QUATERNIONF_MUL_AVX_LINUX = {
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x10, (byte) 0x46, (byte) 0x10, (byte) 0xC5,
          /// (byte) 0xF8, (byte) 0x10, (byte) 0x4A, (byte) 0x10, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04,
          /// (byte) 0xD0, (byte) 0xE5, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xD8, (byte) 0x7A,
          /// (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xE1, (byte) 0x01, (byte) 0xC5, (byte) 0xD8,
          /// (byte) 0x59, (byte) 0xD2, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xE1, (byte) 0x9E,
          /// (byte) 0xC4, (byte) 0xE2, (byte) 0x61, (byte) 0xA8, (byte) 0xE2, (byte) 0xC5, (byte) 0xD8, (byte) 0x57,
          /// (byte) 0x15, (byte) 0x23, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0xC4, (byte) 0xE3, (byte) 0x79,
          /// (byte) 0x04, (byte) 0xD9, (byte) 0x7B, (byte) 0xC4, (byte) 0xE2, (byte) 0x79, (byte) 0x18, (byte) 0x66,
          /// (byte) 0x10, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xC0, (byte) 0x9F, (byte) 0xC4,
          /// (byte) 0xE2, (byte) 0x71, (byte) 0xA8, (byte) 0xE2, (byte) 0xC4, (byte) 0xE2, (byte) 0x61, (byte) 0xBC,
          /// (byte) 0xE0, (byte) 0xC5, (byte) 0xF8, (byte) 0x11, (byte) 0x61, (byte) 0x10,
          /// (byte) 0xC3, // <- RET
          /// (byte) 0x90, // <- NOP
          /// // below is data for a hand-crafted RIP-relative load in a VBROADCASTSS instruction above
          /// // so we don't actually need a .DATA section but add some data after the RET.
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x80,
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00 };
  /// static final byte[] QUATERNIONF_MUL_AVX_WINDOWS = {
          /// (byte) 0xC5, (byte) 0xF8, (byte) 0x10, (byte) 0x42, (byte) 0x10, (byte) 0xC4,
          /// (byte) 0xC1, (byte) 0x78, (byte) 0x10, (byte) 0x48, (byte) 0x10, (byte) 0xC4, (byte) 0xE3, (byte) 0x79,
          /// (byte) 0x04, (byte) 0xD0, (byte) 0xE5, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xD8,
          /// (byte) 0x7A, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xE1, (byte) 0x01, (byte) 0xC5,
          /// (byte) 0xD8, (byte) 0x59, (byte) 0xD2, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xE1,
          /// (byte) 0x9E, (byte) 0xC4, (byte) 0xE2, (byte) 0x61, (byte) 0xA8, (byte) 0xE2, (byte) 0xC5, (byte) 0xD8,
          /// (byte) 0x57, (byte) 0x15, (byte) 0x24, (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0xC4, (byte) 0xE3,
          /// (byte) 0x79, (byte) 0x04, (byte) 0xD9, (byte) 0x7B, (byte) 0xC4, (byte) 0xE2, (byte) 0x79, (byte) 0x18,
          /// (byte) 0x62, (byte) 0x10, (byte) 0xC4, (byte) 0xE3, (byte) 0x79, (byte) 0x04, (byte) 0xC0, (byte) 0x9F,
          /// (byte) 0xC4, (byte) 0xE2, (byte) 0x71, (byte) 0xA8, (byte) 0xE2, (byte) 0xC4, (byte) 0xE2, (byte) 0x61,
          /// (byte) 0xBC, (byte) 0xE0, (byte) 0xC4, (byte) 0xC1, (byte) 0x78, (byte) 0x11, (byte) 0x61, (byte) 0x10,
          /// (byte) 0xC3, // <- RET
          /// (byte) 0x90, // <- NOP
          /// // below is data for a hand-crafted RIP-relative load in a VBROADCASTSS instruction above
          /// // so we don't actually need a .DATA section but add some data after the RET.
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x80,
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
          /// (byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00 };

  /// static {
    /// boolean _canUseJvmci = false;
    /// try {
      /// boolean _isWindows = System.getProperty("os.name").contains("Windows");
      /// JVMCIRuntime jvmciRuntime = JVMCI.getRuntime();
      /// JVMCIBackend jvmciBackend = jvmciRuntime.getHostJVMCIBackend();
      /// TargetDescription targetDesc = jvmciBackend.getTarget();
      /// Architecture arch = targetDesc.arch;
      /// AMD64 amd64arch = (AMD64) arch;
      /// Set features = amd64arch.getFeatures();
      /// if (!features.contains(AMD64.CPUFeature.AVX) || !features.contains(AMD64.CPUFeature.FMA))
        /// throw new AssertionError("CPU lacks AVX or FMA support");
      /// checkMatrix4f();
      /// checkMatrix4d();
      /// checkQuaternionf();
      /// installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4f_mul", Matrix4f.class, Matrix4f.class, Matrix4f.class), _isWindows ? MATRIX4F_MUL_AVX_WINDOWS : MATRIX4F_MUL_AVX_LINUX);
      /// installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4d_mul", Matrix4d.class, Matrix4d.class, Matrix4d.class), _isWindows ? MATRIX4D_MUL_AVX_WINDOWS : MATRIX4D_MUL_AVX_LINUX);
      /// installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4f_invert", Matrix4f.class, Matrix4f.class), _isWindows ? MATRIX4F_INVERT_AVX_WINDOWS : MATRIX4F_INVERT_AVX_LINUX);
      /// installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4f_transpose", Matrix4f.class, Matrix4f.class), _isWindows ? MATRIX4F_TRANSPOSE_AVX_WINDOWS : MATRIX4F_TRANSPOSE_AVX_LINUX);
      /// installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Matrix4f_set", Matrix4f.class, Matrix4f.class), _isWindows ? MATRIX4F_SET_AVX_WINDOWS : MATRIX4F_SET_AVX_LINUX);
      /// installCode(jvmciBackend, JvmciCode.class.getDeclaredMethod("__Quaternionf_mul", Quaternionf.class, Quaternionf.class, Quaternionf.class), _isWindows ? QUATERNIONF_MUL_AVX_WINDOWS : QUATERNIONF_MUL_AVX_LINUX);
      /// _canUseJvmci = true;
    /// } catch (Throwable e) {
      /// if (Options.DEBUG) {
        /// System.out.println("[JOML] JVMCI not available, because: " + e.getClass().getName() + ": " + e.getMessage());
      /// }
    /// }
    /// canUseJvmci = _canUseJvmci;
  /// }
  /// private static void checkMatrix4f() throws Throwable {
    /// Field f;
    /// sun.misc.Unsafe u = unsafeInstance();
    /// for (int i = 0; i < 16; i++) {
      /// int c = i >>> 2;
      /// int r = i & 3;
      /// f = Matrix4f.class.getDeclaredField("m" + c + r);
      /// long offset = u.objectFieldOffset(f);
      /// if (offset != 16 + (i << 2))
        /// throw new AssertionError("invalid Matrix4f field offset");
    /// }
  /// }
  /// private static void checkMatrix4d() throws Throwable {
    /// Field f;
    /// sun.misc.Unsafe u = unsafeInstance();
    /// for (int i = 0; i < 16; i++) {
      /// int c = i >>> 2;
      /// int r = i & 3;
      /// f = Matrix4d.class.getDeclaredField("m" + c + r);
      /// long offset = u.objectFieldOffset(f);
      /// if (offset != 16 + (i << 3))
        /// throw new AssertionError("invalid Matrix4d field offset");
    /// }
  /// }
  /// private static void checkQuaternionf() throws Throwable {
    /// sun.misc.Unsafe u = unsafeInstance();
    /// if (u.objectFieldOffset(Quaternionf.class.getDeclaredField("w")) != 16L ||
        /// u.objectFieldOffset(Quaternionf.class.getDeclaredField("x")) != 20L ||
        /// u.objectFieldOffset(Quaternionf.class.getDeclaredField("y")) != 24L ||
        /// u.objectFieldOffset(Quaternionf.class.getDeclaredField("z")) != 28L)
      /// throw new AssertionError("invalid Quaternionf field offset");
  /// }
  /// private static sun.misc.Unsafe unsafeInstance() throws SecurityException {
    /// java.lang.reflect.Field[] fields = sun.misc.Unsafe.class.getDeclaredFields();
    /// for (int i = 0; i < fields.length; i++) {
      /// java.lang.reflect.Field field = fields[i];
      /// if (!field.getType().equals(sun.misc.Unsafe.class))
        /// continue;
      /// int modifiers = field.getModifiers();
      /// if (!(java.lang.reflect.Modifier.isStatic(modifiers) && java.lang.reflect.Modifier.isFinal(modifiers)))
        /// continue;
      /// field.setAccessible(true);
      /// try {
        /// return (sun.misc.Unsafe) field.get(null);
      /// } catch (IllegalAccessException e) {
        /// /* Ignore */
      /// }
      /// break;
    /// }
    /// throw new AssertionError("no sun.misc.Unsafe available");
  /// }
  /// private static void installCode(JVMCIBackend jvmciBackend, Method m, byte[] code) throws Throwable {
    /// ResolvedJavaMethod rm = jvmciBackend.getMetaAccess().lookupJavaMethod(m);
    /// CompiledCode nm = new HotSpotCompiledNmethod(m.getName(), code, code.length, new Site[0],
            /// new Assumptions.Assumption[0], new ResolvedJavaMethod[0], new HotSpotCompiledCode.Comment[0], new byte[0], 1,
            /// new DataPatch[0], true, 0, null, (HotSpotResolvedJavaMethod) rm, JVMCICompiler.INVOCATION_ENTRY_BCI, 1, 0L, false);
    /// CodeCacheProvider codeCache = jvmciBackend.getCodeCache();
    /// // funny business below:
    /// // When we invoke CodeCache.setDefaultCode() non-reflectively, the JVM's class verifier aborts with a JNI error
    /// // that it cannot find the class jdk.vm.ci.code.CompiledCode.
    /// // This occurs on every JVM between 8 and 20, whenever the JVMCI module and its packages are not added/exported.
    /// // To circumvent the verifier, we will invoke that method reflectively.
    /// Method setDefaultCodeMethod = codeCache.getClass().getMethod("setDefaultCode", ResolvedJavaMethod.class, CompiledCode.class);
    /// setDefaultCodeMethod.invoke(codeCache, rm, nm);
  /// }

  /// static native void __Matrix4f_mul(Matrix4f a, Matrix4f b, Matrix4f r);
  /// static native void __Matrix4d_mul(Matrix4d a, Matrix4d b, Matrix4d r);
  /// static native void __Matrix4f_invert(Matrix4f a, Matrix4f r);
  /// static native void __Matrix4f_transpose(Matrix4f a, Matrix4f r);
  /// static native void __Matrix4f_set(Matrix4f a, Matrix4f r);
  /// static native void __Quaternionf_mul(Quaternionf a, Quaternionf b, Quaternionf r);
/// }
//#endif
