/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.config;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import com.gtnewhorizon.gtnhlib.config.PacketSyncConfig;
import com.gtnewhorizon.gtnhlib.config.SyncedConfigElement;
import com.gtnewhorizon.gtnhlib.network.NetworkHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;

public final class ConfigSyncHandler {
    static final Map<String, SyncedConfigElement> syncedElements = new Object2ObjectOpenHashMap<String, SyncedConfigElement>();
    private static boolean hasSyncedValues = false;

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer entityPlayer = event.player;
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
        MinecraftServer server = MinecraftServer.getServer();
        if (server.isSinglePlayer() && !((IntegratedServer)server).getPublic()) {
            return;
        }
        NetworkHandler.instance.sendTo((IMessage)new PacketSyncConfig(syncedElements.values()), playerMP);
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (!hasSyncedValues) {
            return;
        }
        hasSyncedValues = false;
        for (SyncedConfigElement element : syncedElements.values()) {
            element.restoreValue();
        }
    }

    static void onSync(PacketSyncConfig packet) {
        for (Object2ObjectMap.Entry entry : packet.syncedElements.object2ObjectEntrySet()) {
            SyncedConfigElement element = syncedElements.get(entry.getKey());
            if (element == null) continue;
            try {
                hasSyncedValues = true;
                element.setSyncValue((String)entry.getValue());
            }
            catch (ConfigException e) {
                ConfigurationManager.LOGGER.error("Failed to sync element {}", new Object[]{element, e});
            }
        }
    }

    static boolean hasSyncedValues() {
        return hasSyncedValues;
    }
}

