/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.concurrent.cas;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class CasAdapter<ImmutableView, MutableView> {
    private final AtomicReference<@NotNull ImmutableView> reference;

    public CasAdapter(@NotNull ImmutableView initial) {
        Objects.requireNonNull(initial);
        this.reference = new AtomicReference<ImmutableView>(initial);
    }

    @NotNull
    public final ImmutableView read() {
        return this.reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void overwrite(@NotNull ImmutableView newValue) {
        Objects.requireNonNull(newValue);
        CasAdapter casAdapter = this;
        synchronized (casAdapter) {
            this.reference.set(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R mutate(@NotNull @NotNull Function<@NotNull MutableView, R> mutator) {
        while (true) {
            CasAdapter casAdapter = this;
            synchronized (casAdapter) {
                ImmutableView oldVal = this.reference.get();
                MutableView mutVal = this.mutableCopyOf(oldVal);
                Objects.requireNonNull(mutVal);
                R retVal = mutator.apply(mutVal);
                ImmutableView newVal = this.immutableCopyOf(mutVal);
                Objects.requireNonNull(newVal);
                boolean success = this.reference.compareAndSet(oldVal, newVal);
                if (success) {
                    return retVal;
                }
            }
        }
    }

    @NotNull
    protected abstract MutableView mutableCopyOf(@NotNull ImmutableView var1);

    @NotNull
    protected abstract ImmutableView immutableCopyOf(@NotNull MutableView var1);
}

