/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.capability.item.ItemSink;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InsertionItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleItemSink
implements ItemSink {
    protected int[] allowedSinkSlots;

    @Override
    public void resetSink() {
        this.allowedSinkSlots = null;
    }

    @Override
    public void setAllowedSinkSlots(int @Nullable [] slots) {
        this.allowedSinkSlots = slots;
    }

    @Override
    public int store(ImmutableItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        InventoryIterator iter = this.sinkIterator();
        InsertionItemStack insertion = new InsertionItemStack(stack);
        while (iter.hasNext()) {
            iter.next();
            insertion.set(iter.insert(insertion, false));
            if (!insertion.isEmpty()) continue;
            return 0;
        }
        return insertion.getStackSize();
    }

    @Override
    @NotNull
    public InventoryIterator sinkIterator() {
        return this.iterator(this.allowedSinkSlots);
    }

    @NotNull
    protected abstract InventoryIterator iterator(int[] var1);
}

