/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.postprocessing;

import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.I3DGeometryRenderer;
import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.shaders.PostProcessingRenderer;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class PostProcessingManager {
    private static PostProcessingManager instance;
    private final List<GeometryRenderer> delayedRenderers = new ArrayList<GeometryRenderer>();
    private int renderersIndex;
    private final List<PostProcessingRenderer> postProcessingRenderers = new ArrayList<PostProcessingRenderer>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void applyPostProcessingEffects(RenderWorldLastEvent event) {
        int upperLimit;
        int cachedRenderers = this.delayedRenderers.size();
        if (cachedRenderers >= 16 && (upperLimit = cachedRenderers / 4) > this.renderersIndex) {
            this.delayedRenderers.subList(upperLimit, cachedRenderers).clear();
        }
        if (this.renderersIndex != 0) {
            for (int i = 0; i < this.renderersIndex; ++i) {
                GeometryRenderer renderer = this.delayedRenderers.get(i);
                GL11.glTranslated((double)renderer.viewX, (double)renderer.viewY, (double)renderer.viewZ);
                renderer.renderer.render(renderer.data);
                GL11.glTranslated((double)(-renderer.viewX), (double)(-renderer.viewY), (double)(-renderer.viewZ));
                renderer.data = null;
            }
            this.renderersIndex = 0;
        }
        int length = this.postProcessingRenderers.size();
        for (int i = 0; i < length; ++i) {
            PostProcessingRenderer renderer = this.postProcessingRenderers.get(i);
            if (!renderer.needsRendering) continue;
            renderer.needsRendering = false;
            renderer.render(event.partialTicks);
        }
    }

    public static PostProcessingManager getInstance() {
        if (instance == null) {
            instance = new PostProcessingManager();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
        return instance;
    }

    public void registerPostProcessingRenderer(PostProcessingRenderer shader) {
        this.postProcessingRenderers.add(shader);
    }

    public void addDelayedRenderer(I3DGeometryRenderer renderer, double viewX, double viewY, double viewZ) {
        this.addDelayedRenderer(renderer, viewX, viewY, viewZ, null);
    }

    public void addDelayedRenderer(I3DGeometryRenderer renderer, double viewX, double viewY, double viewZ, Object data) {
        if (this.delayedRenderers.size() > this.renderersIndex) {
            this.delayedRenderers.get(this.renderersIndex).set(renderer, (float)viewX, (float)viewY, (float)viewZ, data);
        } else {
            this.delayedRenderers.add(new GeometryRenderer(renderer, (float)viewX, (float)viewY, (float)viewZ, data));
        }
        ++this.renderersIndex;
    }

    public static double viewX(double x) {
        return x - RenderManager.renderPosX;
    }

    public static double viewY(double y) {
        return y - RenderManager.renderPosY;
    }

    public static double viewZ(double z) {
        return z - RenderManager.renderPosZ;
    }

    private static final class GeometryRenderer {
        private I3DGeometryRenderer renderer;
        private double viewX;
        private double viewY;
        private double viewZ;
        private Object data;

        public GeometryRenderer(I3DGeometryRenderer renderer, double viewX, double viewY, double viewZ, Object data) {
            this.set(renderer, viewX, viewY, viewZ, data);
        }

        public void set(I3DGeometryRenderer renderer, double viewX, double viewY, double viewZ, Object data) {
            this.renderer = renderer;
            this.viewX = viewX;
            this.viewY = viewY;
            this.viewZ = viewZ;
            this.data = data;
        }
    }
}

