/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.item.FastImmutableItemStack;
import com.gtnewhorizon.gtnhlib.util.ItemUtil;
import com.gtnewhorizon.gtnhlib.util.data.ImmutableItemMeta;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface ImmutableItemStack
extends ImmutableItemMeta {
    public int getStackSize();

    public NBTTagCompound getTag();

    default public boolean isEmpty() {
        return this.getStackSize() <= 0;
    }

    default public ItemStack toStack() {
        return this.toStack(this.getStackSize());
    }

    default public ImmutableItemStack copy() {
        return new FastImmutableItemStack(this.toStack());
    }

    @Override
    default public ItemStack toStack(int amount) {
        int meta = this.getItemMeta();
        ItemStack stack = new ItemStack(this.getItem(), amount, meta == Short.MAX_VALUE ? 0 : meta);
        NBTTagCompound tag = this.getTag();
        if (tag != null) {
            stack.setTagCompound((NBTTagCompound)tag.copy());
        }
        return stack;
    }

    default public ItemStack toStackFast() {
        return this.toStackFast(this.getStackSize());
    }

    default public ItemStack toStackFast(int amount) {
        int meta = this.getItemMeta();
        ItemStack stack = new ItemStack(this.getItem(), amount, meta == Short.MAX_VALUE ? 0 : meta);
        NBTTagCompound tag = this.getTag();
        if (tag != null) {
            stack.setTagCompound(tag);
        }
        return stack;
    }

    @Override
    default public boolean matches(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.getItem() != stack.getItem()) {
            return false;
        }
        if (this.getItemMeta() == Short.MAX_VALUE) {
            return true;
        }
        if (ItemUtil.getStackMeta(stack) == Short.MAX_VALUE) {
            return true;
        }
        if (this.getItemMeta() != ItemUtil.getStackMeta(stack)) {
            return false;
        }
        return Objects.equals(this.getTag(), stack.getTagCompound());
    }

    default public boolean matches(ImmutableItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.getItem() != stack.getItem()) {
            return false;
        }
        if (this.getItemMeta() == Short.MAX_VALUE) {
            return true;
        }
        if (stack.getItemMeta() == Short.MAX_VALUE) {
            return true;
        }
        if (this.getItemMeta() != stack.getItemMeta()) {
            return false;
        }
        return Objects.equals(this.getTag(), stack.getTag());
    }
}

