/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.OreDictionary;

@EventBusSubscriber(side={Side.CLIENT})
public class AnimatedTooltipHandler {
    private static final Map<ItemStack, Supplier<String>> tooltipMap = new ItemStackMap<Supplier<String>>(false);
    public static final String BLACK;
    public static final String DARK_BLUE;
    public static final String DARK_GREEN;
    public static final String DARK_AQUA;
    public static final String DARK_RED;
    public static final String DARK_PURPLE;
    public static final String GOLD;
    public static final String GRAY;
    public static final String DARK_GRAY;
    public static final String BLUE;
    public static final String GREEN;
    public static final String AQUA;
    public static final String RED;
    public static final String LIGHT_PURPLE;
    public static final String YELLOW;
    public static final String WHITE;
    public static final String OBFUSCATED;
    public static final String BOLD;
    public static final String STRIKETHROUGH;
    public static final String UNDERLINE;
    public static final String ITALIC;
    public static final String RESET;
    public static final Supplier<String> NEW_LINE;

    @SafeVarargs
    public static Supplier<String> chain(Supplier<String> ... parts) {
        return () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (Supplier text : parts) {
                stringBuilder.append((String)text.get());
            }
            return stringBuilder.toString();
        };
    }

    public static Supplier<String> text(String text) {
        return () -> text;
    }

    public static Supplier<String> text(String format, Object ... args) {
        return () -> String.format(Locale.ROOT, format, args);
    }

    public static Supplier<String> translatedText(String translationKey) {
        return () -> StatCollector.translateToLocal((String)translationKey);
    }

    public static Supplier<String> translatedText(String translationKey, Object ... args) {
        return () -> StatCollector.translateToLocalFormatted((String)translationKey, (Object[])args);
    }

    public static Supplier<String> animatedText(String text, int posstep, int delay, String ... formattingArray) {
        if (text == null || text.isEmpty() || formattingArray == null || formattingArray.length == 0) {
            return () -> "";
        }
        int finalDelay = Math.max(delay, 1);
        int finalPosstep = Math.max(posstep, 0);
        return () -> {
            StringBuilder sb = new StringBuilder(text.length() * 3);
            int offset = (int)(System.currentTimeMillis() / (long)finalDelay % (long)formattingArray.length);
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                int indexColorArray = (i * finalPosstep + formattingArray.length - offset) % formattingArray.length;
                sb.append(formattingArray[indexColorArray]);
                sb.append(c);
            }
            return sb.toString();
        };
    }

    public static Supplier<String> animatedText(String format, Object[] args, int posstep, int delay, String ... formattingArray) {
        return AnimatedTooltipHandler.animatedText(String.format(Locale.ROOT, format, args), posstep, delay, formattingArray);
    }

    public static Supplier<String> translatedAnimatedText(String translationKey, int posstep, int delay, String ... formattingArray) {
        return AnimatedTooltipHandler.animatedText(StatCollector.translateToLocal((String)translationKey), posstep, delay, formattingArray);
    }

    public static Supplier<String> translatedAnimatedText(String translationKey, Object[] args, int posstep, int delay, String ... formattingArray) {
        return AnimatedTooltipHandler.animatedText(StatCollector.translateToLocalFormatted((String)translationKey, (Object[])args), posstep, delay, formattingArray);
    }

    public static void addOredictTooltip(String oredictName, Supplier<String> tooltip) {
        for (ItemStack item : OreDictionary.getOres((String)oredictName)) {
            AnimatedTooltipHandler.addItemTooltip(item, tooltip);
        }
    }

    public static void addItemTooltip(String modID, String registryName, int meta, Supplier<String> tooltip) {
        Item item = GameRegistry.findItem((String)modID, (String)registryName);
        if (item == null || tooltip == null) {
            return;
        }
        tooltipMap.merge(new ItemStack(item, 1, meta), tooltip, (a, b) -> AnimatedTooltipHandler.chain(a, NEW_LINE, b));
    }

    public static void addItemTooltip(ItemStack item, Supplier<String> tooltip) {
        if (item == null || tooltip == null) {
            return;
        }
        tooltipMap.merge(item, tooltip, (a, b) -> AnimatedTooltipHandler.chain(a, NEW_LINE, b));
    }

    @SubscribeEvent
    public static void renderTooltip(ItemTooltipEvent event) {
        Supplier<String> tooltip = tooltipMap.get(event.itemStack);
        if (tooltip == null) {
            return;
        }
        String text = tooltip.get();
        if (text == null) {
            return;
        }
        event.toolTip.addAll(Arrays.asList(text.split("\n")));
    }

    static {
        AQUA = EnumChatFormatting.AQUA.toString();
        BLACK = EnumChatFormatting.BLACK.toString();
        BLUE = EnumChatFormatting.BLUE.toString();
        BOLD = EnumChatFormatting.BOLD.toString();
        DARK_AQUA = EnumChatFormatting.DARK_AQUA.toString();
        DARK_BLUE = EnumChatFormatting.DARK_BLUE.toString();
        DARK_GRAY = EnumChatFormatting.DARK_GRAY.toString();
        DARK_GREEN = EnumChatFormatting.DARK_GREEN.toString();
        DARK_PURPLE = EnumChatFormatting.DARK_PURPLE.toString();
        DARK_RED = EnumChatFormatting.DARK_RED.toString();
        GOLD = EnumChatFormatting.GOLD.toString();
        GRAY = EnumChatFormatting.GRAY.toString();
        GREEN = EnumChatFormatting.GREEN.toString();
        ITALIC = EnumChatFormatting.ITALIC.toString();
        LIGHT_PURPLE = EnumChatFormatting.LIGHT_PURPLE.toString();
        OBFUSCATED = EnumChatFormatting.OBFUSCATED.toString();
        RED = EnumChatFormatting.RED.toString();
        RESET = EnumChatFormatting.RESET.toString();
        STRIKETHROUGH = EnumChatFormatting.STRIKETHROUGH.toString();
        UNDERLINE = EnumChatFormatting.UNDERLINE.toString();
        WHITE = EnumChatFormatting.WHITE.toString();
        YELLOW = EnumChatFormatting.YELLOW.toString();
        NEW_LINE = () -> "\n";
    }
}

