/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.loading;

import com.google.gson.Gson;
import com.gtnewhorizon.gtnhlib.client.model.loading.ModelRegistry;
import com.gtnewhorizon.gtnhlib.client.model.state.StateModelMap;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.JSONModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.JsonException;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface ResourceLoc<T> {
    default public T load(Supplier<@NotNull T> defaultSrc, Gson gson) {
        ResourceLocation jsonPath = new ResourceLocation(this.owner(), this.prefix() + this.path() + this.ext());
        try {
            InputStream is = Minecraft.getMinecraft().getResourceManager().getResource(jsonPath).getInputStream();
            return (T)gson.fromJson((Reader)new InputStreamReader(is), this.clazz());
        }
        catch (JsonException e) {
            ModelRegistry.MODEL_LOGGER.error("Failed to parse {}:{}", new Object[]{this.owner(), jsonPath.getResourcePath()});
        }
        catch (IOException e) {
            ModelRegistry.MODEL_LOGGER.error("Could not load {}:{}", new Object[]{this.owner(), jsonPath.getResourcePath()});
        }
        return defaultSrc.get();
    }

    public String prefix();

    public String owner();

    public String path();

    public String ext();

    public Class<T> clazz();

    public static final class StateLoc
    implements ResourceLoc<StateModelMap> {
        private final String owner;
        private final String path;

        public StateLoc(String owner, String path) {
            this.owner = owner;
            this.path = path;
        }

        @Override
        public String prefix() {
            return "blockstates/";
        }

        @Override
        public String ext() {
            return ".json";
        }

        @Override
        public Class<StateModelMap> clazz() {
            return StateModelMap.class;
        }

        @Override
        public String owner() {
            return this.owner;
        }

        @Override
        public String path() {
            return this.path;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StateLoc that = (StateLoc)obj;
            return Objects.equals(this.owner, that.owner) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.path);
        }
    }

    public static final class ModelLoc
    implements ResourceLoc<JSONModel> {
        private final String owner;
        private final String path;

        public ModelLoc(String owner, String path) {
            this.owner = owner;
            this.path = path;
        }

        public static ModelLoc fromStr(String id) {
            int sepIdx = id.indexOf(58);
            if (sepIdx < 0) {
                return new ModelLoc("minecraft", id);
            }
            return new ModelLoc(id.substring(0, sepIdx), id.substring(sepIdx + 1));
        }

        @Override
        public String prefix() {
            return "models/";
        }

        @Override
        public String ext() {
            return ".json";
        }

        @Override
        public Class<JSONModel> clazz() {
            return JSONModel.class;
        }

        @Override
        public String owner() {
            return this.owner;
        }

        @Override
        public String path() {
            return this.path;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ModelLoc that = (ModelLoc)obj;
            return Objects.equals(this.owner, that.owner) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.path);
        }
    }
}

