/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.state;

import com.gtnewhorizon.gtnhlib.client.model.BakeData;
import com.gtnewhorizon.gtnhlib.client.model.JSONVariant;
import com.gtnewhorizon.gtnhlib.client.model.Weighted;
import com.gtnewhorizon.gtnhlib.client.model.baked.BakedModel;
import com.gtnewhorizon.gtnhlib.client.model.baked.MultipartModel;
import com.gtnewhorizon.gtnhlib.client.model.state.StateModelMap;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.MonopartDough;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.UnbakedModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

public class MultipartState
implements StateModelMap,
UnbakedModel {
    private final ObjectList<Case> multipart;

    MultipartState(ObjectList<Case> multipart) {
        this.multipart = multipart;
    }

    @Override
    public UnbakedModel selectModel(Map<String, String> properties) {
        return this;
    }

    @Override
    public BakedModel bake(BakeData data) {
        Object2ObjectArrayMap<Case.Condition, BakedModel> bread = new Object2ObjectArrayMap<Case.Condition, BakedModel>(this.multipart.size());
        for (Case c : this.multipart) {
            bread.put(c.when, new MonopartDough(c.apply).bake());
        }
        return new MultipartModel(bread);
    }

    @ApiStatus.Internal
    public static final class Case {
        private final ObjectList<Weighted<JSONVariant>> apply;
        private final Condition when;

        public Case(ObjectList<Weighted<JSONVariant>> apply, Condition when) {
            this.apply = apply;
            this.when = when;
        }

        public ObjectList<Weighted<JSONVariant>> apply() {
            return this.apply;
        }

        public Condition when() {
            return this.when;
        }

        public static interface Condition {
            public static final Condition TRUE = state -> true;

            public boolean matches(Map<String, String> var1);
        }

        static final class StateCon
        implements Condition {
            private final String key;
            private final ObjectList<String> values;

            StateCon(String key, ObjectList<String> values) {
                this.key = key;
                this.values = values;
            }

            @Override
            public boolean matches(Map<String, String> state) {
                String val = state.get(this.key);
                for (String v : this.values) {
                    if (!v.equals(val)) continue;
                    return true;
                }
                return false;
            }

            public String key() {
                return this.key;
            }

            public ObjectList<String> values() {
                return this.values;
            }
        }

        static final class MultiCon
        implements Condition {
            private final boolean requireAll;
            private final ObjectList<Condition> matches;

            MultiCon(boolean requireAll, ObjectList<Condition> matches) {
                this.requireAll = requireAll;
                this.matches = matches;
            }

            @Override
            public boolean matches(Map<String, String> state) {
                if (this.requireAll) {
                    for (Condition m : this.matches) {
                        if (m.matches(state)) continue;
                        return false;
                    }
                    return true;
                }
                for (Condition m : this.matches) {
                    if (!m.matches(state)) continue;
                    return true;
                }
                return false;
            }

            public boolean requireAll() {
                return this.requireAll;
            }

            public ObjectList<Condition> matches() {
                return this.matches;
            }
        }
    }
}

