/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.keybind;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.keybind.IKeyPressedListener;
import com.gtnewhorizon.gtnhlib.keybind.PacketKeyDown;
import com.gtnewhorizon.gtnhlib.network.NetworkHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.lwjgl.input.Keyboard;

@EventBusSubscriber(side={Side.CLIENT})
public final class SyncedKeybind {
    private static final Int2ObjectMap<SyncedKeybind> KEYBINDS = new Int2ObjectOpenHashMap<SyncedKeybind>();
    private static int syncIndex = 0;
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keybinding;
    @SideOnly(value=Side.CLIENT)
    private int keyCode;
    @SideOnly(value=Side.CLIENT)
    private boolean isKeyDown;
    private static final Int2BooleanMap updatingKeyDown = new Int2BooleanOpenHashMap();
    private final WeakHashMap<EntityPlayerMP, Boolean> serverMapping = new WeakHashMap();
    private final WeakHashMap<EntityPlayerMP, Set<IKeyPressedListener>> playerListeners = new WeakHashMap();
    private final Set<IKeyPressedListener> globalListeners = Collections.newSetFromMap(new WeakHashMap());

    private SyncedKeybind(Supplier<Supplier<KeyBinding>> keybindingGetter) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.keybinding = keybindingGetter.get().get();
        }
        KEYBINDS.put(syncIndex++, this);
    }

    private SyncedKeybind(int keyCode) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.keyCode = keyCode;
        }
        KEYBINDS.put(syncIndex++, this);
    }

    private SyncedKeybind(String nameKey, String categoryKey, int keyCode) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.keybinding = (KeyBinding)this.createKeyBinding(nameKey, categoryKey, keyCode);
        }
        KEYBINDS.put(syncIndex++, this);
    }

    public static SyncedKeybind createFromMC(Supplier<Supplier<KeyBinding>> mcKeybinding) {
        return new SyncedKeybind(mcKeybinding);
    }

    public static SyncedKeybind create(int keyCode) {
        return new SyncedKeybind(keyCode);
    }

    public static SyncedKeybind createConfigurable(String nameKey, String categoryKey, int keyCode) {
        return new SyncedKeybind(nameKey, categoryKey, keyCode);
    }

    public boolean isKeyDown(EntityPlayer player) {
        if (player.worldObj.isRemote) {
            if (this.keybinding != null) {
                return this.keybinding.getIsKeyPressed();
            }
            return Keyboard.isKeyDown((int)this.keyCode);
        }
        Boolean isKeyDown = this.serverMapping.get((EntityPlayerMP)player);
        return isKeyDown != null ? isKeyDown : false;
    }

    public SyncedKeybind registerPlayerListener(EntityPlayerMP player, IKeyPressedListener listener) {
        Set listenerSet = this.playerListeners.computeIfAbsent(player, k -> Collections.newSetFromMap(new WeakHashMap()));
        listenerSet.add(listener);
        return this;
    }

    public void removePlayerListener(EntityPlayerMP player, IKeyPressedListener listener) {
        Set<IKeyPressedListener> listenerSet = this.playerListeners.get(player);
        if (listenerSet != null) {
            listenerSet.remove(listener);
        }
    }

    public SyncedKeybind registerGlobalListener(IKeyPressedListener listener) {
        this.globalListeners.add(listener);
        return this;
    }

    public void removeGlobalListener(IKeyPressedListener listener) {
        this.globalListeners.remove(listener);
    }

    static SyncedKeybind getFromSyncId(int id) {
        return (SyncedKeybind)KEYBINDS.get(id);
    }

    @SideOnly(value=Side.CLIENT)
    private Object createKeyBinding(String nameLangKey, String category, int button) {
        KeyBinding keybinding = new KeyBinding(nameLangKey, button, category);
        ClientRegistry.registerKeyBinding((KeyBinding)keybinding);
        return keybinding;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            updatingKeyDown.clear();
            for (Int2ObjectMap.Entry entry : KEYBINDS.int2ObjectEntrySet()) {
                SyncedKeybind keybind = (SyncedKeybind)entry.getValue();
                boolean previousKeyDown = keybind.isKeyDown;
                keybind.isKeyDown = keybind.keybinding != null ? keybind.keybinding.getIsKeyPressed() : Keyboard.isKeyDown((int)keybind.keyCode);
                if (previousKeyDown == keybind.isKeyDown) continue;
                updatingKeyDown.put(entry.getIntKey(), keybind.isKeyDown);
            }
            if (!updatingKeyDown.isEmpty()) {
                NetworkHandler.instance.sendToServer((IMessage)new PacketKeyDown(updatingKeyDown));
            }
        }
    }

    void serverActivate(boolean keyDown, EntityPlayerMP player) {
        this.serverMapping.put(player, keyDown);
        Set<IKeyPressedListener> listenerSet = this.playerListeners.get(player);
        if (listenerSet != null && !listenerSet.isEmpty()) {
            for (IKeyPressedListener listener : listenerSet) {
                listener.onKeyPressed(player, this, keyDown);
            }
        }
        for (IKeyPressedListener listener : this.globalListeners) {
            listener.onKeyPressed(player, this, keyDown);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getKeyCode() {
        return this.keybinding != null ? this.keybinding.getKeyCode() : this.keyCode;
    }

    @SideOnly(value=Side.CLIENT)
    public KeyBinding getKeybinding() {
        return this.keybinding;
    }
}

