/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.mixins.early;

import com.gtnewhorizon.gtnhlib.brigadier.BrigadierApi;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CommandHandler.class})
public class MixinCommandHandler {
    @Unique
    private boolean gtnhlib$isServerCommandManager() {
        return this instanceof ServerCommandManager;
    }

    @Inject(method={"executeCommand"}, at={@At(value="NEW", target="()Lnet/minecraft/command/CommandNotFoundException;")}, cancellable=true)
    private void gtnhlib$fallbackToBrigadier(ICommandSender sender, String command, CallbackInfoReturnable<Integer> cir) {
        if (this.gtnhlib$isServerCommandManager()) {
            int value = BrigadierApi.executeCommand(sender, command);
            cir.setReturnValue((Object)value);
        }
    }

    @Inject(method={"getPossibleCommands(Lnet/minecraft/command/ICommandSender;Ljava/lang/String;)Ljava/util/List;"}, at={@At(value="RETURN")}, cancellable=true)
    private void gtnhlib$gatherBrigadierSuggestion(ICommandSender sender, String command, CallbackInfoReturnable<List<String>> cir) {
        if (this.gtnhlib$isServerCommandManager()) {
            List returnValue = (List)cir.getReturnValue();
            List<String> possibleCommands = BrigadierApi.getPossibleCommands(sender, command);
            if (returnValue == null) {
                cir.setReturnValue(possibleCommands);
            } else {
                returnValue.addAll(possibleCommands);
            }
        }
    }

    @Inject(method={"getPossibleCommands(Lnet/minecraft/command/ICommandSender;)Ljava/util/List;"}, at={@At(value="RETURN")})
    private void gtnhlib$gatherBrigadierCommands(ICommandSender sender, CallbackInfoReturnable<List<ICommand>> cir) {
        if (this.gtnhlib$isServerCommandManager()) {
            Collection<ICommand> possibleCommands = BrigadierApi.getPossibleCommands(sender);
            ((List)cir.getReturnValue()).addAll(possibleCommands);
        }
    }
}

