/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.brigadier;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrigadierApi {
    @Generated
    private static final Logger log = LogManager.getLogger(BrigadierApi.class);
    @Nullable
    private static CommandDispatcher<ICommandSender> dispatcher = new CommandDispatcher();

    @NotNull
    public static CommandDispatcher<ICommandSender> getCommandDispatcher() {
        return Objects.requireNonNull(dispatcher);
    }

    @ApiStatus.Internal
    public static void init() {
        dispatcher = new CommandDispatcher();
        BrigadierApi.registerTestCommand();
    }

    @ApiStatus.Internal
    public static void clear() {
        dispatcher = null;
    }

    private static void registerTestCommand() {
        BrigadierApi.getCommandDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("brigadier").executes(ctx -> {
            ((ICommandSender)ctx.getSource()).func_145747_a((IChatComponent)new ChatComponentText("Brigadier from GTNHLib!"));
            return 1;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("stringValue", StringArgumentType.greedyString()).requires(src -> src.func_70003_b(4, ""))).suggests((ctx, builder) -> {
            for (EntityPlayer playerEntity : ((ICommandSender)ctx.getSource()).func_130014_f_().field_73010_i) {
                builder.suggest(playerEntity.func_70005_c_());
            }
            for (int i = 0; i < 9; ++i) {
                builder.suggest(i);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String value = StringArgumentType.getString(ctx, "stringValue");
            ((ICommandSender)ctx.getSource()).func_145747_a((IChatComponent)new ChatComponentText("Brigadier: " + value));
            return 1;
        })));
    }

    public static int executeCommand(ICommandSender sender, String command) {
        try {
            return BrigadierApi.getCommandDispatcher().execute(command, sender);
        }
        catch (CommandSyntaxException e) {
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    public static List<String> getPossibleCommands(ICommandSender sender, String command) {
        ParseResults<ICommandSender> parse = BrigadierApi.getCommandDispatcher().parse(command, sender);
        try {
            return BrigadierApi.getCommandDispatcher().getCompletionSuggestions(parse).get().getList().stream().map(Suggestion::getText).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Exception occurred while completing command '{}'", new Object[]{command, e});
            return Collections.emptyList();
        }
    }

    public static Collection<ICommand> getPossibleCommands(ICommandSender sender) {
        return BrigadierApi.getCommandDispatcher().getRoot().getChildren().stream().filter(c -> c.canUse(sender)).map(BrigadierApi::toICommandForHelpCommand).collect(Collectors.toList());
    }

    private static ICommand toICommandForHelpCommand(final CommandNode<?> node) {
        return new ICommand(){

            public String func_71517_b() {
                return node.getName();
            }

            public String func_71518_a(ICommandSender sender) {
                return node.getUsageText();
            }

            public List<String> func_71514_a() {
                return Collections.emptyList();
            }

            public void func_71515_b(ICommandSender sender, String[] args) {
            }

            public boolean func_71519_b(ICommandSender sender) {
                return false;
            }

            public List<String> func_71516_a(ICommandSender sender, String[] args) {
                return Collections.emptyList();
            }

            public boolean func_82358_a(String[] args, int index) {
                return false;
            }

            public int compareTo(@NotNull Object o) {
                if (o instanceof ICommand) {
                    ICommand otherCommand = (ICommand)o;
                    return this.func_71517_b().compareTo(otherCommand.func_71517_b());
                }
                return 0;
            }

            public String toString() {
                return "DummyICommand{" + node.toString() + "}";
            }

            public int hashCode() {
                return node.hashCode();
            }
        };
    }
}

