/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model;

import com.gtnewhorizon.gtnhlib.client.model.baked.BakedModel;
import com.gtnewhorizon.gtnhlib.client.model.loading.ModelRegistry;
import com.gtnewhorizon.gtnhlib.client.model.state.BlockState;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.api.util.NormI8;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

@ThreadSafeISBRH(perThread=true)
public class ModelISBRH
implements ISimpleBlockRenderingHandler {
    public static final int JSON_ISBRH_ID = RenderingRegistry.getNextAvailableRenderId();
    private final Random RAND = new Random();

    protected BakedModel getModel(IBlockAccess world, Block block, int meta, int x, int y, int z) {
        return ModelRegistry.getBakedModel(new BlockState(block, meta));
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Random random;
        if (world instanceof World) {
            World worldIn = (World)world;
            random = worldIn.field_73012_v;
        } else {
            random = this.RAND;
        }
        Random random2 = random;
        Tessellator tesselator = TessellatorManager.get();
        int meta = world.func_72805_g(x, y, z);
        BakedModel model = this.getModel(world, block, meta, x, y, z);
        int color = model.getColor(world, x, y, z, block, meta, random2);
        boolean rendered = false;
        for (ModelQuadFacing dir : ModelQuadFacing.DIRECTIONS) {
            List<ModelQuadView> quads = model.getQuads(world, x, y, z, block, meta, dir, random2, color, null);
            if (quads.isEmpty()) continue;
            rendered = true;
            for (ModelQuadView quad : quads) {
                if (quad.getColorIndex() != -1 && color == -1) {
                    color = block.func_149720_d(world, x, y, z);
                }
                float r = (float)(color & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color >> 16 & 0xFF) / 255.0f;
                int lm = this.getLightMap(block, quad, dir, world, x, y, z, renderer);
                tesselator.func_78380_c(lm);
                float shade = ModelISBRH.diffuseLight(quad.getComputedFaceNormal());
                tesselator.func_78386_a(r * shade, g * shade, b * shade);
                this.renderQuad(quad, x, y, z, tesselator, null);
            }
        }
        return rendered;
    }

    protected void renderQuad(ModelQuadView quad, float x, float y, float z, Tessellator tessellator, @Nullable IIcon overrideIcon) {
        for (int i = 0; i < 4; ++i) {
            tessellator.func_78374_a((double)(quad.getX(i) + x), (double)(quad.getY(i) + y), (double)(quad.getZ(i) + z), (double)quad.getTexU(i), (double)quad.getTexV(i));
        }
    }

    private int getLightMap(Block block, ModelQuadView quad, ModelQuadFacing dir, IBlockAccess world, int x, int y, int z, RenderBlocks rb) {
        float avgPos = this.getAveragePos(quad, dir);
        switch (dir) {
            case POS_X: 
            case POS_Y: 
            case POS_Z: {
                if (!((double)avgPos >= 1.0)) break;
                int lx = x + dir.getStepX();
                int ly = y + dir.getStepY();
                int lz = z + dir.getStepZ();
                return block.func_149677_c(world, lx, ly, lz);
            }
            case NEG_X: 
            case NEG_Y: 
            case NEG_Z: {
                if (!((double)avgPos <= 0.0)) break;
                int lx = x + dir.getStepX();
                int ly = y + dir.getStepY();
                int lz = z + dir.getStepZ();
                return block.func_149677_c(world, lx, ly, lz);
            }
        }
        if (block.getLightOpacity(world, x, y, z) != 0) {
            return block.func_149677_c(world, x, y, z);
        }
        int lm = block.func_149677_c(world, x, y, z);
        for (int i = 0; i < 6; ++i) {
            ModelQuadFacing neighbor = ModelQuadFacing.DIRECTIONS[i];
            int lx = x + neighbor.getStepX();
            int ly = y + neighbor.getStepY();
            int lz = z + neighbor.getStepZ();
            lm = Math.max(lm, block.func_149677_c(world, lx, ly, lz));
        }
        return lm;
    }

    private float getAveragePos(ModelQuadView quad, ModelQuadFacing dir) {
        float avg = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float f;
            switch (dir.getAxis()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case X: {
                    f = quad.getX(i);
                    break;
                }
                case Y: {
                    f = quad.getY(i);
                    break;
                }
                case Z: {
                    f = quad.getZ(i);
                }
            }
            avg += f;
        }
        return avg / 4.0f;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return JSON_ISBRH_ID;
    }

    public static float diffuseLight(int normal) {
        float nx = NormI8.unpackX(normal);
        float ny = NormI8.unpackY(normal);
        float nz = NormI8.unpackZ(normal);
        return Math.min(nx * nx * 0.6f + ny * ny * ((3.0f + ny) / 4.0f) + nz * nz * 0.8f, 1.0f);
    }
}

