/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.baked;

import com.gtnewhorizon.gtnhlib.client.model.baked.BakedModel;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.Nullable;

public final class PileOfQuads
implements BakedModel {
    public static final PileOfQuads BLANK = new PileOfQuads(new HashMap<ModelQuadFacing, ArrayList<ModelQuadView>>());
    private final SidedQuadStore sidedQuadStore;

    public PileOfQuads(SidedQuadStore sidedQuadStore) {
        this.sidedQuadStore = sidedQuadStore;
    }

    public PileOfQuads(Map<ModelQuadFacing, ArrayList<ModelQuadView>> sidedQuadStore) {
        this(new SidedQuadStore(sidedQuadStore));
    }

    @Override
    public List<ModelQuadView> getQuads(@Nullable IBlockAccess world, int x, int y, int z, Block block, int meta, ModelQuadFacing dir, Random random, int color, @Nullable Supplier<ModelQuadViewMutable> quadPool) {
        return this.sidedQuadStore.getQuads(dir);
    }

    public static class SidedQuadStore {
        private static final ObjectImmutableList<ModelQuadView> EMPTY = ObjectImmutableList.of();
        private final ObjectImmutableList<ModelQuadView> up;
        private final ObjectImmutableList<ModelQuadView> down;
        private final ObjectImmutableList<ModelQuadView> north;
        private final ObjectImmutableList<ModelQuadView> south;
        private final ObjectImmutableList<ModelQuadView> west;
        private final ObjectImmutableList<ModelQuadView> east;
        private final ObjectImmutableList<ModelQuadView> unknown;

        public SidedQuadStore(Map<ModelQuadFacing, ArrayList<ModelQuadView>> sidedQuadStore) {
            this.up = this.lockList((List<ModelQuadView>)sidedQuadStore.get((Object)ModelQuadFacing.POS_Y));
            this.down = this.lockList((List<ModelQuadView>)sidedQuadStore.get((Object)ModelQuadFacing.NEG_Y));
            this.north = this.lockList((List<ModelQuadView>)sidedQuadStore.get((Object)ModelQuadFacing.NEG_Z));
            this.south = this.lockList((List<ModelQuadView>)sidedQuadStore.get((Object)ModelQuadFacing.POS_Z));
            this.west = this.lockList((List<ModelQuadView>)sidedQuadStore.get((Object)ModelQuadFacing.NEG_X));
            this.east = this.lockList((List<ModelQuadView>)sidedQuadStore.get((Object)ModelQuadFacing.POS_X));
            this.unknown = this.lockList((List<ModelQuadView>)sidedQuadStore.get((Object)ModelQuadFacing.UNASSIGNED));
        }

        public List<ModelQuadView> getQuads(ModelQuadFacing dir) {
            ObjectImmutableList<ModelQuadView> objectImmutableList;
            switch (dir) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case POS_Y: {
                    objectImmutableList = this.up;
                    break;
                }
                case NEG_Y: {
                    objectImmutableList = this.down;
                    break;
                }
                case NEG_Z: {
                    objectImmutableList = this.north;
                    break;
                }
                case POS_Z: {
                    objectImmutableList = this.south;
                    break;
                }
                case NEG_X: {
                    objectImmutableList = this.west;
                    break;
                }
                case POS_X: {
                    objectImmutableList = this.east;
                    break;
                }
                case UNASSIGNED: {
                    objectImmutableList = this.unknown;
                }
            }
            return objectImmutableList;
        }

        private ObjectImmutableList<ModelQuadView> lockList(@Nullable List<ModelQuadView> list) {
            if (list == null || list.isEmpty()) {
                return EMPTY;
            }
            return new ObjectImmutableList<ModelQuadView>(list);
        }
    }
}

