/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.state;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gtnewhorizon.gtnhlib.client.model.JSONVariant;
import com.gtnewhorizon.gtnhlib.client.model.Weighted;
import com.gtnewhorizon.gtnhlib.client.model.loading.ResourceLoc;
import com.gtnewhorizon.gtnhlib.client.model.state.MonopartState;
import com.gtnewhorizon.gtnhlib.client.model.state.MultipartState;
import com.gtnewhorizon.gtnhlib.client.model.state.StateModelMap;
import com.gtnewhorizon.gtnhlib.util.JsonUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StateDeserializer
implements JsonDeserializer<StateModelMap> {
    public StateModelMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject root = json.getAsJsonObject();
        if (root.has("variants")) {
            return new MonopartState(this.loadVariants(root));
        }
        if (root.has("multipart")) {
            return new MultipartState(this.loadMultipart(root));
        }
        throw new JsonParseException("No 'variants' or 'multipart' tag found in blockstate JSON!");
    }

    private Object2ObjectMap<MonopartState.StateMatch, ObjectList<Weighted<JSONVariant>>> loadVariants(JsonObject root) {
        JsonObject variants = root.getAsJsonObject("variants");
        Set entries = variants.entrySet();
        Object2ObjectOpenHashMap<MonopartState.StateMatch, ObjectList<Weighted<JSONVariant>>> map = new Object2ObjectOpenHashMap<MonopartState.StateMatch, ObjectList<Weighted<JSONVariant>>>(entries.size());
        entries.forEach(v -> {
            String match = (String)v.getKey();
            JsonElement variant = (JsonElement)v.getValue();
            map.put(new MonopartState.StateMatch(match), this.loadVariants(variant));
        });
        return map;
    }

    private ObjectList<MultipartState.Case> loadMultipart(JsonObject root) {
        JsonArray multipart = root.getAsJsonArray("multipart");
        ObjectArrayList<MultipartState.Case> cases = new ObjectArrayList<MultipartState.Case>(multipart.size());
        for (JsonElement c : multipart) {
            JsonObject kase = c.getAsJsonObject();
            ObjectList<Weighted<JSONVariant>> variants = this.loadVariants(kase.get("apply"));
            MultipartState.Case.Condition condition = this.loadCondition(kase);
            cases.add(new MultipartState.Case(variants, condition));
        }
        return cases;
    }

    private ObjectList<Weighted<JSONVariant>> loadVariants(JsonElement variants) {
        ObjectArrayList<Weighted<JSONVariant>> loadedJSONVariants;
        if (variants.isJsonArray()) {
            JsonArray models = variants.getAsJsonArray();
            loadedJSONVariants = new ObjectArrayList(models.size());
            for (JsonElement m : models) {
                JsonObject model = m.getAsJsonObject();
                loadedJSONVariants.add(this.loadVariant(model));
            }
        } else {
            JsonObject model = variants.getAsJsonObject();
            loadedJSONVariants = new ObjectArrayList<Weighted<JSONVariant>>(1);
            loadedJSONVariants.add(this.loadVariant(model));
        }
        return loadedJSONVariants;
    }

    private Weighted<JSONVariant> loadVariant(JsonObject variant) {
        return JSONVariant.weightedVariant(ResourceLoc.ModelLoc.fromStr(JsonUtil.loadStr(variant, "model")), JsonUtil.loadInt(variant, "x", 0), JsonUtil.loadInt(variant, "y", 0), JsonUtil.loadBool(variant, "uvlock", false), JsonUtil.loadInt(variant, "weight", 1));
    }

    private MultipartState.Case.Condition loadCondition(JsonObject kase) {
        if (!kase.has("when")) {
            return MultipartState.Case.Condition.TRUE;
        }
        JsonObject when = kase.getAsJsonObject("when");
        if (when.has("AND")) {
            JsonArray cons = when.getAsJsonArray("AND");
            ObjectArrayList<MultipartState.Case.Condition> conditions = this.LoadMultiCons(cons);
            return new MultipartState.Case.MultiCon(true, conditions);
        }
        if (when.has("OR")) {
            JsonArray cons = when.getAsJsonArray("OR");
            ObjectArrayList<MultipartState.Case.Condition> conditions = this.LoadMultiCons(cons);
            return new MultipartState.Case.MultiCon(false, conditions);
        }
        return new MultipartState.Case.MultiCon(true, StateDeserializer.loadStateCons(when));
    }

    private ObjectArrayList<MultipartState.Case.Condition> LoadMultiCons(JsonArray cons) {
        ObjectArrayList<MultipartState.Case.Condition> conditions = new ObjectArrayList<MultipartState.Case.Condition>(cons.size());
        for (JsonElement con : cons) {
            conditions.add(new MultipartState.Case.MultiCon(true, StateDeserializer.loadStateCons(con.getAsJsonObject())));
        }
        return conditions;
    }

    @NotNull
    private static ObjectArrayList<MultipartState.Case.Condition> loadStateCons(JsonObject obj) {
        Set conds = obj.entrySet();
        ObjectArrayList<MultipartState.Case.Condition> condList = new ObjectArrayList<MultipartState.Case.Condition>(conds.size());
        for (Map.Entry cond : conds) {
            String stateName = (String)cond.getKey();
            ObjectArrayList<String> stateValues = new ObjectArrayList<String>(((JsonElement)cond.getValue()).getAsString().split("\\|"));
            condList.add(new MultipartState.Case.StateCon(stateName, stateValues));
        }
        return condList;
    }
}

