/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vertex;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.writers.IWriteQuads;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class VertexFormat {
    protected final ImmutableList<VertexFormatElement> elements;
    protected final int vertexSize;
    protected final IntList offsets = new IntArrayList();
    protected IWriteQuads quadWriter;
    protected static final List<SetupBufferState> setupBufferStateOverrride = new ArrayList<SetupBufferState>();
    protected static final List<ClearBufferState> clearBufferStateOverrride = new ArrayList<ClearBufferState>();

    public static void registerSetupBufferStateOverride(SetupBufferState override) {
        setupBufferStateOverrride.add(override);
    }

    public static void registerClearBufferStateOverride(ClearBufferState override) {
        clearBufferStateOverrride.add(override);
    }

    public VertexFormat(ImmutableList<VertexFormatElement> elements) {
        this(elements, null);
    }

    public VertexFormat(ImmutableList<VertexFormatElement> elements, IWriteQuads quadWriter) {
        this.elements = elements;
        int i = 0;
        for (VertexFormatElement element : elements) {
            this.offsets.add(i);
            i += element.getByteSize();
        }
        this.vertexSize = i;
        this.quadWriter = quadWriter;
    }

    public void setupBufferState(long l) {
        int i;
        int overrideSize = setupBufferStateOverrride.size();
        for (i = 0; i < overrideSize; ++i) {
            SetupBufferState override = setupBufferStateOverrride.get(i);
            if (!override.run(this, l)) continue;
            return;
        }
        i = this.getVertexSize();
        ImmutableList<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        for (int j = 0; j < listSize; ++j) {
            ((VertexFormatElement)list.get(j)).setupBufferState(l + (long)this.offsets.getInt(j), i);
        }
    }

    public void clearBufferState() {
        int overrideSize = clearBufferStateOverrride.size();
        for (int i = 0; i < overrideSize; ++i) {
            ClearBufferState override = clearBufferStateOverrride.get(i);
            if (!override.run(this)) continue;
            return;
        }
        ImmutableList<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            ((VertexFormatElement)list.get(i)).clearBufferState();
        }
    }

    public boolean canWriteQuads() {
        return this.quadWriter != null;
    }

    public void writeQuad(ModelQuadView quad, ByteBuffer byteBuffer) {
        if (this.quadWriter == null) {
            throw new IllegalStateException("No quad writer set");
        }
        this.quadWriter.writeQuad(quad, byteBuffer);
    }

    @Generated
    public ImmutableList<VertexFormatElement> getElements() {
        return this.elements;
    }

    @Generated
    public int getVertexSize() {
        return this.vertexSize;
    }

    @FunctionalInterface
    public static interface SetupBufferState {
        public boolean run(VertexFormat var1, long var2);
    }

    @FunctionalInterface
    public static interface ClearBufferState {
        public boolean run(VertexFormat var1);
    }
}

