/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vertex;

import java.util.function.IntConsumer;
import lombok.Generated;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class VertexFormatElement {
    protected final Type type;
    protected final Usage usage;
    protected final int index;
    protected final int count;
    protected final int byteSize;

    public VertexFormatElement(int index, Type type, Usage usage, int count) {
        this.index = index;
        this.type = type;
        this.usage = usage;
        this.count = count;
        this.byteSize = type.getSize() * count;
    }

    public void setupBufferState(long offset, int stride) {
        this.usage.setupBufferState(this.count, this.type.getGlType(), stride, offset, this.index);
    }

    public void clearBufferState() {
        this.usage.clearBufferState(this.index);
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Usage getUsage() {
        return this.usage;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public int getByteSize() {
        return this.byteSize;
    }

    public static enum Type {
        FLOAT(4, "Float", 5126),
        UBYTE(1, "Unsigned Byte", 5121),
        BYTE(1, "Byte", 5120),
        USHORT(2, "Unsigned Short", 5123),
        SHORT(2, "Short", 5122),
        UINT(4, "Unsigned Int", 5125),
        INT(4, "Int", 5124);

        private final int size;
        private final String name;
        private final int glType;

        private Type(int size, String name, int glType) {
            this.size = size;
            this.name = name;
            this.glType = glType;
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public int getGlType() {
            return this.glType;
        }
    }

    public static enum Usage {
        POSITION("Position", (size, type, stride, pointer, index) -> {
            GL11.glVertexPointer((int)size, (int)type, (int)stride, (long)pointer);
            GL11.glEnableClientState((int)32884);
        }, index -> GL11.glDisableClientState((int)32884)),
        NORMAL("Normal", (size, type, stride, pointer, index) -> {
            GL11.glNormalPointer((int)type, (int)stride, (long)pointer);
            GL11.glEnableClientState((int)32885);
        }, index -> GL11.glDisableClientState((int)32885)),
        COLOR("Vertex Color", (size, type, stride, pointer, index) -> {
            GL11.glColorPointer((int)size, (int)type, (int)stride, (long)pointer);
            GL11.glEnableClientState((int)32886);
        }, index -> GL11.glDisableClientState((int)32886)),
        PRIMARY_UV("UV 0", (size, type, stride, pointer, index) -> {
            GL11.glTexCoordPointer((int)size, (int)type, (int)stride, (long)pointer);
            GL11.glEnableClientState((int)32888);
        }, index -> GL11.glDisableClientState((int)32888)),
        SECONDARY_UV("UV 1-31", (size, type, stride, pointer, index) -> {
            GL13.glClientActiveTexture((int)(33984 + index));
            GL11.glTexCoordPointer((int)size, (int)type, (int)stride, (long)pointer);
            GL11.glEnableClientState((int)32888);
            GL13.glClientActiveTexture((int)33984);
        }, index -> {
            GL13.glClientActiveTexture((int)(33984 + index));
            GL11.glDisableClientState((int)32888);
            GL13.glClientActiveTexture((int)33984);
        }),
        PADDING("Padding", (size, type, stride, pointer, index) -> {}, index -> {}),
        GENERIC("Generic", (size, type, stride, pointer, index) -> {
            GL20.glEnableVertexAttribArray((int)index);
            GL20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)false, (int)stride, (long)pointer);
        }, GL20::glDisableVertexAttribArray);

        private final String name;
        private final SetupState setupState;
        private final IntConsumer clearState;

        private Usage(String name, SetupState setupState, IntConsumer clearState) {
            this.name = name;
            this.setupState = setupState;
            this.clearState = clearState;
        }

        private void setupBufferState(int size, int type, int stride, long pointer, int index) {
            this.setupState.setupBufferState(size, type, stride, pointer, index);
        }

        public void clearBufferState(int index) {
            this.clearState.accept(index);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        static interface SetupState {
            public void setupBufferState(int var1, int var2, int var3, long var4, int var6);
        }
    }
}

