/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties;

import com.gtnewhorizon.gtnhlib.client.renderer.cel.api.util.NormI8;
import java.util.Arrays;
import lombok.Generated;

public enum ModelQuadFacing {
    POS_X(1, 0, 0, Axis.X),
    POS_Y(0, 1, 0, Axis.Y),
    POS_Z(0, 0, 1, Axis.Z),
    NEG_X(-1, 0, 0, Axis.X),
    NEG_Y(0, -1, 0, Axis.Y),
    NEG_Z(0, 0, -1, Axis.Z),
    UNASSIGNED(0, 0, 0, null);

    public static final ModelQuadFacing[] VALUES;
    public static final ModelQuadFacing[] DIRECTIONS;
    public static final ModelQuadFacing[] HORIZONTAL_DIRECTIONS;
    public static final Axis[] AXES;
    public static final int COUNT;
    public static final int NONE = 0;
    public static final int ALL;
    private final int packedNormal;
    private final int stepX;
    private final int stepY;
    private final int stepZ;
    private final Axis axis;

    private ModelQuadFacing(int stepX, int stepY, int stepZ, Axis axis) {
        this.stepX = stepX;
        this.stepY = stepY;
        this.stepZ = stepZ;
        this.axis = axis;
        this.packedNormal = NormI8.pack(stepX, stepY, stepZ);
    }

    public ModelQuadFacing getOpposite() {
        ModelQuadFacing modelQuadFacing;
        switch (this) {
            case POS_Y: {
                modelQuadFacing = NEG_Y;
                break;
            }
            case NEG_Y: {
                modelQuadFacing = POS_Y;
                break;
            }
            case POS_X: {
                modelQuadFacing = NEG_X;
                break;
            }
            case NEG_X: {
                modelQuadFacing = POS_X;
                break;
            }
            case POS_Z: {
                modelQuadFacing = NEG_Z;
                break;
            }
            case NEG_Z: {
                modelQuadFacing = POS_Z;
                break;
            }
            default: {
                modelQuadFacing = UNASSIGNED;
            }
        }
        return modelQuadFacing;
    }

    public boolean isDirection() {
        return this != UNASSIGNED;
    }

    @Generated
    public int getPackedNormal() {
        return this.packedNormal;
    }

    @Generated
    public int getStepX() {
        return this.stepX;
    }

    @Generated
    public int getStepY() {
        return this.stepY;
    }

    @Generated
    public int getStepZ() {
        return this.stepZ;
    }

    @Generated
    public Axis getAxis() {
        return this.axis;
    }

    static {
        VALUES = ModelQuadFacing.values();
        DIRECTIONS = (ModelQuadFacing[])Arrays.stream(VALUES).filter(facing -> facing != UNASSIGNED).toArray(ModelQuadFacing[]::new);
        HORIZONTAL_DIRECTIONS = (ModelQuadFacing[])Arrays.stream(DIRECTIONS).filter(facing -> facing.axis != Axis.Y).toArray(ModelQuadFacing[]::new);
        AXES = Axis.values();
        COUNT = VALUES.length;
        ALL = (1 << COUNT) - 1;
    }

    public static enum Axis {
        X,
        Y,
        Z;


        public ModelQuadFacing getFacing(boolean positive) {
            ModelQuadFacing modelQuadFacing;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case X: {
                    if (positive) {
                        modelQuadFacing = POS_X;
                        break;
                    }
                    modelQuadFacing = NEG_X;
                    break;
                }
                case Y: {
                    if (positive) {
                        modelQuadFacing = POS_Y;
                        break;
                    }
                    modelQuadFacing = NEG_Y;
                    break;
                }
                case Z: {
                    modelQuadFacing = positive ? POS_Z : NEG_Z;
                }
            }
            return modelQuadFacing;
        }
    }
}

